@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.integrationspaces.kotlin

import com.pulumi.azurenative.integrationspaces.ApplicationArgs.builder
import com.pulumi.azurenative.integrationspaces.kotlin.inputs.TrackingDataStoreArgs
import com.pulumi.azurenative.integrationspaces.kotlin.inputs.TrackingDataStoreArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * An integration application under space.
 * Azure REST API version: 2023-11-14-preview.
 * ## Example Usage
 * ### CreateOrUpdateApplication
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var application = new AzureNative.IntegrationSpaces.Application("application", new()
 *     {
 *         ApplicationName = "Application1",
 *         Description = "This is the user provided description of the application.",
 *         Location = "CentralUS",
 *         ResourceGroupName = "testrg",
 *         SpaceName = "Space1",
 *         Tags =
 *         {
 *             { "key1", "Value1" },
 *         },
 *         TrackingDataStores =
 *         {
 *             { "dataStoreName1", new AzureNative.IntegrationSpaces.Inputs.TrackingDataStoreArgs
 *             {
 *                 DataStoreIngestionUri = "https://ingest-someClusterName.someRegionName.kusto.windows.net",
 *                 DataStoreResourceId = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/testrg/providers/Microsoft.Kusto/Clusters/cluster1",
 *                 DataStoreUri = "https://someClusterName.someRegionName.kusto.windows.net",
 *                 DatabaseName = "testDatabase1",
 *             } },
 *             { "dataStoreName2", new AzureNative.IntegrationSpaces.Inputs.TrackingDataStoreArgs
 *             {
 *                 DataStoreIngestionUri = "https://ingest-someClusterName.someRegionName.kusto.windows.net",
 *                 DataStoreResourceId = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/testrg/providers/Microsoft.Kusto/Clusters/cluster1",
 *                 DataStoreUri = "https://someClusterName.someRegionName.kusto.windows.net",
 *                 DatabaseName = "testDatabase1",
 *             } },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/integrationspaces/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := integrationspaces.NewApplication(ctx, "application", &integrationspaces.ApplicationArgs{
 * 			ApplicationName:   pulumi.String("Application1"),
 * 			Description:       pulumi.String("This is the user provided description of the application."),
 * 			Location:          pulumi.String("CentralUS"),
 * 			ResourceGroupName: pulumi.String("testrg"),
 * 			SpaceName:         pulumi.String("Space1"),
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("Value1"),
 * 			},
 * 			TrackingDataStores: integrationspaces.TrackingDataStoreMap{
 * 				"dataStoreName1": &integrationspaces.TrackingDataStoreArgs{
 * 					DataStoreIngestionUri: pulumi.String("https://ingest-someClusterName.someRegionName.kusto.windows.net"),
 * 					DataStoreResourceId:   pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/testrg/providers/Microsoft.Kusto/Clusters/cluster1"),
 * 					DataStoreUri:          pulumi.String("https://someClusterName.someRegionName.kusto.windows.net"),
 * 					DatabaseName:          pulumi.String("testDatabase1"),
 * 				},
 * 				"dataStoreName2": &integrationspaces.TrackingDataStoreArgs{
 * 					DataStoreIngestionUri: pulumi.String("https://ingest-someClusterName.someRegionName.kusto.windows.net"),
 * 					DataStoreResourceId:   pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/testrg/providers/Microsoft.Kusto/Clusters/cluster1"),
 * 					DataStoreUri:          pulumi.String("https://someClusterName.someRegionName.kusto.windows.net"),
 * 					DatabaseName:          pulumi.String("testDatabase1"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.integrationspaces.Application;
 * import com.pulumi.azurenative.integrationspaces.ApplicationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var application = new Application("application", ApplicationArgs.builder()
 *             .applicationName("Application1")
 *             .description("This is the user provided description of the application.")
 *             .location("CentralUS")
 *             .resourceGroupName("testrg")
 *             .spaceName("Space1")
 *             .tags(Map.of("key1", "Value1"))
 *             .trackingDataStores(Map.ofEntries(
 *                 Map.entry("dataStoreName1", Map.ofEntries(
 *                     Map.entry("dataStoreIngestionUri", "https://ingest-someClusterName.someRegionName.kusto.windows.net"),
 *                     Map.entry("dataStoreResourceId", "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/testrg/providers/Microsoft.Kusto/Clusters/cluster1"),
 *                     Map.entry("dataStoreUri", "https://someClusterName.someRegionName.kusto.windows.net"),
 *                     Map.entry("databaseName", "testDatabase1")
 *                 )),
 *                 Map.entry("dataStoreName2", Map.ofEntries(
 *                     Map.entry("dataStoreIngestionUri", "https://ingest-someClusterName.someRegionName.kusto.windows.net"),
 *                     Map.entry("dataStoreResourceId", "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/testrg/providers/Microsoft.Kusto/Clusters/cluster1"),
 *                     Map.entry("dataStoreUri", "https://someClusterName.someRegionName.kusto.windows.net"),
 *                     Map.entry("databaseName", "testDatabase1")
 *                 ))
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:integrationspaces:Application Application1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IntegrationSpaces/spaces/{spaceName}/applications/{applicationName}
 * ```
 * @property applicationName The name of the Application
 * @property description The description of the resource.
 * @property location The geo-location where the resource lives
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property spaceName The name of the space
 * @property tags Resource tags.
 * @property trackingDataStores The tracking data stores.
 */
public data class ApplicationArgs(
    public val applicationName: Output<String>? = null,
    public val description: Output<String>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val spaceName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val trackingDataStores: Output<Map<String, TrackingDataStoreArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.integrationspaces.ApplicationArgs> {
    override fun toJava(): com.pulumi.azurenative.integrationspaces.ApplicationArgs =
        com.pulumi.azurenative.integrationspaces.ApplicationArgs.builder()
            .applicationName(applicationName?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .spaceName(spaceName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .trackingDataStores(
                trackingDataStores?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ApplicationArgs].
 */
@PulumiTagMarker
public class ApplicationArgsBuilder internal constructor() {
    private var applicationName: Output<String>? = null

    private var description: Output<String>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var spaceName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var trackingDataStores: Output<Map<String, TrackingDataStoreArgs>>? = null

    /**
     * @param value The name of the Application
     */
    @JvmName("unjxnvuhsxemtjbv")
    public suspend fun applicationName(`value`: Output<String>) {
        this.applicationName = value
    }

    /**
     * @param value The description of the resource.
     */
    @JvmName("cmoqtajhfjbsvkns")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("vartxpwonyxmahli")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("oiylotjqthgfrdyb")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the space
     */
    @JvmName("iwbiybskbhcpvmfv")
    public suspend fun spaceName(`value`: Output<String>) {
        this.spaceName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("iwlprxlfjomkccod")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The tracking data stores.
     */
    @JvmName("aiaaiewhlacigvlg")
    public suspend fun trackingDataStores(`value`: Output<Map<String, TrackingDataStoreArgs>>) {
        this.trackingDataStores = value
    }

    /**
     * @param value The name of the Application
     */
    @JvmName("lngpbvgdvxjawani")
    public suspend fun applicationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationName = mapped
    }

    /**
     * @param value The description of the resource.
     */
    @JvmName("nenactmuxpxomqjm")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("tmhjmuiiowhjfunk")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("kaoadfumdcwisneu")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the space
     */
    @JvmName("quujkpgfxpkcwgtx")
    public suspend fun spaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.spaceName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("meltmepjyimstaaq")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("gekkyrrmeigpidul")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The tracking data stores.
     */
    @JvmName("vxguahwyajllpkon")
    public suspend fun trackingDataStores(`value`: Map<String, TrackingDataStoreArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trackingDataStores = mapped
    }

    /**
     * @param argument The tracking data stores.
     */
    @JvmName("wvcqmacwnryvgbbn")
    public suspend fun trackingDataStores(
        vararg
        argument: Pair<String, suspend TrackingDataStoreArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                TrackingDataStoreArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.trackingDataStores = mapped
    }

    /**
     * @param values The tracking data stores.
     */
    @JvmName("voerabhtighqbdsu")
    public fun trackingDataStores(vararg values: Pair<String, TrackingDataStoreArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.trackingDataStores = mapped
    }

    internal fun build(): ApplicationArgs = ApplicationArgs(
        applicationName = applicationName,
        description = description,
        location = location,
        resourceGroupName = resourceGroupName,
        spaceName = spaceName,
        tags = tags,
        trackingDataStores = trackingDataStores,
    )
}
