@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.integrationspaces.kotlin

import com.pulumi.azurenative.integrationspaces.BusinessProcessArgs.builder
import com.pulumi.azurenative.integrationspaces.kotlin.inputs.BusinessProcessIdentifierArgs
import com.pulumi.azurenative.integrationspaces.kotlin.inputs.BusinessProcessIdentifierArgsBuilder
import com.pulumi.azurenative.integrationspaces.kotlin.inputs.BusinessProcessMappingItemArgs
import com.pulumi.azurenative.integrationspaces.kotlin.inputs.BusinessProcessMappingItemArgsBuilder
import com.pulumi.azurenative.integrationspaces.kotlin.inputs.BusinessProcessStageArgs
import com.pulumi.azurenative.integrationspaces.kotlin.inputs.BusinessProcessStageArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A business process under application.
 * Azure REST API version: 2023-11-14-preview.
 * ## Example Usage
 * ### CreateOrUpdateBusinessProcess
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var businessProcess = new AzureNative.IntegrationSpaces.BusinessProcess("businessProcess", new()
 *     {
 *         ApplicationName = "Application1",
 *         BusinessProcessMapping =
 *         {
 *             { "Completed", new AzureNative.IntegrationSpaces.Inputs.BusinessProcessMappingItemArgs
 *             {
 *                 LogicAppResourceId = "subscriptions/sub1/resourcegroups/group1/providers/Microsoft.Web/sites/logicApp1",
 *                 OperationName = "CompletedPO",
 *                 OperationType = "Action",
 *                 WorkflowName = "Fulfillment",
 *             } },
 *             { "Denied", new AzureNative.IntegrationSpaces.Inputs.BusinessProcessMappingItemArgs
 *             {
 *                 LogicAppResourceId = "subscriptions/sub1/resourcegroups/group1/providers/Microsoft.Web/sites/logicApp1",
 *                 OperationName = "DeniedPO",
 *                 OperationType = "Action",
 *                 WorkflowName = "Fulfillment",
 *             } },
 *             { "Processing", new AzureNative.IntegrationSpaces.Inputs.BusinessProcessMappingItemArgs
 *             {
 *                 LogicAppResourceId = "subscriptions/sub1/resourcegroups/group1/providers/Microsoft.Web/sites/logicApp1",
 *                 OperationName = "ApprovedPO",
 *                 OperationType = "Action",
 *                 WorkflowName = "PurchaseOrder",
 *             } },
 *             { "Received", new AzureNative.IntegrationSpaces.Inputs.BusinessProcessMappingItemArgs
 *             {
 *                 LogicAppResourceId = "subscriptions/sub1/resourcegroups/group1/providers/Microsoft.Web/sites/logicApp1",
 *                 OperationName = "manual",
 *                 OperationType = "Trigger",
 *                 WorkflowName = "PurchaseOrder",
 *             } },
 *             { "Shipped", new AzureNative.IntegrationSpaces.Inputs.BusinessProcessMappingItemArgs
 *             {
 *                 LogicAppResourceId = "subscriptions/sub1/resourcegroups/group1/providers/Microsoft.Web/sites/logicApp1",
 *                 OperationName = "ShippedPO",
 *                 OperationType = "Action",
 *                 WorkflowName = "Fulfillment",
 *             } },
 *         },
 *         BusinessProcessName = "BusinessProcess1",
 *         BusinessProcessStages =
 *         {
 *             { "Completed", new AzureNative.IntegrationSpaces.Inputs.BusinessProcessStageArgs
 *             {
 *                 Description = "Completed",
 *                 StagesBefore = new[]
 *                 {
 *                     "Shipped",
 *                 },
 *             } },
 *             { "Denied", new AzureNative.IntegrationSpaces.Inputs.BusinessProcessStageArgs
 *             {
 *                 Description = "Denied",
 *                 StagesBefore = new[]
 *                 {
 *                     "Processing",
 *                 },
 *             } },
 *             { "Processing", new AzureNative.IntegrationSpaces.Inputs.BusinessProcessStageArgs
 *             {
 *                 Description = "Processing",
 *                 Properties =
 *                 {
 *                     { "ApprovalState", "String" },
 *                     { "ApproverName", "String" },
 *                     { "POAmount", "Integer" },
 *                 },
 *                 StagesBefore = new[]
 *                 {
 *                     "Received",
 *                 },
 *             } },
 *             { "Received", new AzureNative.IntegrationSpaces.Inputs.BusinessProcessStageArgs
 *             {
 *                 Description = "received",
 *                 Properties =
 *                 {
 *                     { "City", "String" },
 *                     { "Product", "String" },
 *                     { "Quantity", "Integer" },
 *                     { "State", "String" },
 *                 },
 *             } },
 *             { "Shipped", new AzureNative.IntegrationSpaces.Inputs.BusinessProcessStageArgs
 *             {
 *                 Description = "Shipped",
 *                 Properties =
 *                 {
 *                     { "ShipPriority", "Integer" },
 *                     { "TrackingID", "Integer" },
 *                 },
 *                 StagesBefore = new[]
 *                 {
 *                     "Denied",
 *                 },
 *             } },
 *         },
 *         Description = "First Business Process",
 *         Identifier = new AzureNative.IntegrationSpaces.Inputs.BusinessProcessIdentifierArgs
 *         {
 *             PropertyName = "businessIdentifier-1",
 *             PropertyType = "String",
 *         },
 *         ResourceGroupName = "testrg",
 *         SpaceName = "Space1",
 *         TableName = "table1",
 *         TrackingDataStoreReferenceName = "trackingDataStoreReferenceName1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/integrationspaces/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := integrationspaces.NewBusinessProcess(ctx, "businessProcess", &integrationspaces.BusinessProcessArgs{
 * 			ApplicationName: pulumi.String("Application1"),
 * 			BusinessProcessMapping: integrationspaces.BusinessProcessMappingItemMap{
 * 				"Completed": &integrationspaces.BusinessProcessMappingItemArgs{
 * 					LogicAppResourceId: pulumi.String("subscriptions/sub1/resourcegroups/group1/providers/Microsoft.Web/sites/logicApp1"),
 * 					OperationName:      pulumi.String("CompletedPO"),
 * 					OperationType:      pulumi.String("Action"),
 * 					WorkflowName:       pulumi.String("Fulfillment"),
 * 				},
 * 				"Denied": &integrationspaces.BusinessProcessMappingItemArgs{
 * 					LogicAppResourceId: pulumi.String("subscriptions/sub1/resourcegroups/group1/providers/Microsoft.Web/sites/logicApp1"),
 * 					OperationName:      pulumi.String("DeniedPO"),
 * 					OperationType:      pulumi.String("Action"),
 * 					WorkflowName:       pulumi.String("Fulfillment"),
 * 				},
 * 				"Processing": &integrationspaces.BusinessProcessMappingItemArgs{
 * 					LogicAppResourceId: pulumi.String("subscriptions/sub1/resourcegroups/group1/providers/Microsoft.Web/sites/logicApp1"),
 * 					OperationName:      pulumi.String("ApprovedPO"),
 * 					OperationType:      pulumi.String("Action"),
 * 					WorkflowName:       pulumi.String("PurchaseOrder"),
 * 				},
 * 				"Received": &integrationspaces.BusinessProcessMappingItemArgs{
 * 					LogicAppResourceId: pulumi.String("subscriptions/sub1/resourcegroups/group1/providers/Microsoft.Web/sites/logicApp1"),
 * 					OperationName:      pulumi.String("manual"),
 * 					OperationType:      pulumi.String("Trigger"),
 * 					WorkflowName:       pulumi.String("PurchaseOrder"),
 * 				},
 * 				"Shipped": &integrationspaces.BusinessProcessMappingItemArgs{
 * 					LogicAppResourceId: pulumi.String("subscriptions/sub1/resourcegroups/group1/providers/Microsoft.Web/sites/logicApp1"),
 * 					OperationName:      pulumi.String("ShippedPO"),
 * 					OperationType:      pulumi.String("Action"),
 * 					WorkflowName:       pulumi.String("Fulfillment"),
 * 				},
 * 			},
 * 			BusinessProcessName: pulumi.String("BusinessProcess1"),
 * 			BusinessProcessStages: integrationspaces.BusinessProcessStageMap{
 * 				"Completed": &integrationspaces.BusinessProcessStageArgs{
 * 					Description: pulumi.String("Completed"),
 * 					StagesBefore: pulumi.StringArray{
 * 						pulumi.String("Shipped"),
 * 					},
 * 				},
 * 				"Denied": &integrationspaces.BusinessProcessStageArgs{
 * 					Description: pulumi.String("Denied"),
 * 					StagesBefore: pulumi.StringArray{
 * 						pulumi.String("Processing"),
 * 					},
 * 				},
 * 				"Processing": &integrationspaces.BusinessProcessStageArgs{
 * 					Description: pulumi.String("Processing"),
 * 					Properties: pulumi.StringMap{
 * 						"ApprovalState": pulumi.String("String"),
 * 						"ApproverName":  pulumi.String("String"),
 * 						"POAmount":      pulumi.String("Integer"),
 * 					},
 * 					StagesBefore: pulumi.StringArray{
 * 						pulumi.String("Received"),
 * 					},
 * 				},
 * 				"Received": &integrationspaces.BusinessProcessStageArgs{
 * 					Description: pulumi.String("received"),
 * 					Properties: pulumi.StringMap{
 * 						"City":     pulumi.String("String"),
 * 						"Product":  pulumi.String("String"),
 * 						"Quantity": pulumi.String("Integer"),
 * 						"State":    pulumi.String("String"),
 * 					},
 * 				},
 * 				"Shipped": &integrationspaces.BusinessProcessStageArgs{
 * 					Description: pulumi.String("Shipped"),
 * 					Properties: pulumi.StringMap{
 * 						"ShipPriority": pulumi.String("Integer"),
 * 						"TrackingID":   pulumi.String("Integer"),
 * 					},
 * 					StagesBefore: pulumi.StringArray{
 * 						pulumi.String("Denied"),
 * 					},
 * 				},
 * 			},
 * 			Description: pulumi.String("First Business Process"),
 * 			Identifier: &integrationspaces.BusinessProcessIdentifierArgs{
 * 				PropertyName: pulumi.String("businessIdentifier-1"),
 * 				PropertyType: pulumi.String("String"),
 * 			},
 * 			ResourceGroupName:              pulumi.String("testrg"),
 * 			SpaceName:                      pulumi.String("Space1"),
 * 			TableName:                      pulumi.String("table1"),
 * 			TrackingDataStoreReferenceName: pulumi.String("trackingDataStoreReferenceName1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.integrationspaces.BusinessProcess;
 * import com.pulumi.azurenative.integrationspaces.BusinessProcessArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var businessProcess = new BusinessProcess("businessProcess", BusinessProcessArgs.builder()
 *             .applicationName("Application1")
 *             .businessProcessMapping(Map.ofEntries(
 *                 Map.entry("Completed", Map.ofEntries(
 *                     Map.entry("logicAppResourceId", "subscriptions/sub1/resourcegroups/group1/providers/Microsoft.Web/sites/logicApp1"),
 *                     Map.entry("operationName", "CompletedPO"),
 *                     Map.entry("operationType", "Action"),
 *                     Map.entry("workflowName", "Fulfillment")
 *                 )),
 *                 Map.entry("Denied", Map.ofEntries(
 *                     Map.entry("logicAppResourceId", "subscriptions/sub1/resourcegroups/group1/providers/Microsoft.Web/sites/logicApp1"),
 *                     Map.entry("operationName", "DeniedPO"),
 *                     Map.entry("operationType", "Action"),
 *                     Map.entry("workflowName", "Fulfillment")
 *                 )),
 *                 Map.entry("Processing", Map.ofEntries(
 *                     Map.entry("logicAppResourceId", "subscriptions/sub1/resourcegroups/group1/providers/Microsoft.Web/sites/logicApp1"),
 *                     Map.entry("operationName", "ApprovedPO"),
 *                     Map.entry("operationType", "Action"),
 *                     Map.entry("workflowName", "PurchaseOrder")
 *                 )),
 *                 Map.entry("Received", Map.ofEntries(
 *                     Map.entry("logicAppResourceId", "subscriptions/sub1/resourcegroups/group1/providers/Microsoft.Web/sites/logicApp1"),
 *                     Map.entry("operationName", "manual"),
 *                     Map.entry("operationType", "Trigger"),
 *                     Map.entry("workflowName", "PurchaseOrder")
 *                 )),
 *                 Map.entry("Shipped", Map.ofEntries(
 *                     Map.entry("logicAppResourceId", "subscriptions/sub1/resourcegroups/group1/providers/Microsoft.Web/sites/logicApp1"),
 *                     Map.entry("operationName", "ShippedPO"),
 *                     Map.entry("operationType", "Action"),
 *                     Map.entry("workflowName", "Fulfillment")
 *                 ))
 *             ))
 *             .businessProcessName("BusinessProcess1")
 *             .businessProcessStages(Map.ofEntries(
 *                 Map.entry("Completed", Map.ofEntries(
 *                     Map.entry("description", "Completed"),
 *                     Map.entry("stagesBefore", "Shipped")
 *                 )),
 *                 Map.entry("Denied", Map.ofEntries(
 *                     Map.entry("description", "Denied"),
 *                     Map.entry("stagesBefore", "Processing")
 *                 )),
 *                 Map.entry("Processing", Map.ofEntries(
 *                     Map.entry("description", "Processing"),
 *                     Map.entry("properties", Map.ofEntries(
 *                         Map.entry("ApprovalState", "String"),
 *                         Map.entry("ApproverName", "String"),
 *                         Map.entry("POAmount", "Integer")
 *                     )),
 *                     Map.entry("stagesBefore", "Received")
 *                 )),
 *                 Map.entry("Received", Map.ofEntries(
 *                     Map.entry("description", "received"),
 *                     Map.entry("properties", Map.ofEntries(
 *                         Map.entry("City", "String"),
 *                         Map.entry("Product", "String"),
 *                         Map.entry("Quantity", "Integer"),
 *                         Map.entry("State", "String")
 *                     ))
 *                 )),
 *                 Map.entry("Shipped", Map.ofEntries(
 *                     Map.entry("description", "Shipped"),
 *                     Map.entry("properties", Map.ofEntries(
 *                         Map.entry("ShipPriority", "Integer"),
 *                         Map.entry("TrackingID", "Integer")
 *                     )),
 *                     Map.entry("stagesBefore", "Denied")
 *                 ))
 *             ))
 *             .description("First Business Process")
 *             .identifier(Map.ofEntries(
 *                 Map.entry("propertyName", "businessIdentifier-1"),
 *                 Map.entry("propertyType", "String")
 *             ))
 *             .resourceGroupName("testrg")
 *             .spaceName("Space1")
 *             .tableName("table1")
 *             .trackingDataStoreReferenceName("trackingDataStoreReferenceName1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:integrationspaces:BusinessProcess BusinessProcess1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IntegrationSpaces/spaces/{spaceName}/applications/{applicationName}/businessProcesses/{businessProcessName}
 * ```
 * @property applicationName The name of the Application
 * @property businessProcessMapping The business process mapping.
 * @property businessProcessName The name of the business process
 * @property businessProcessStages The business process stages.
 * @property description The description of the business process.
 * @property identifier The business process identifier.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property spaceName The name of the space
 * @property tableName The table name of the business process.
 * @property trackingDataStoreReferenceName The tracking data store reference name.
 */
public data class BusinessProcessArgs(
    public val applicationName: Output<String>? = null,
    public val businessProcessMapping: Output<Map<String, BusinessProcessMappingItemArgs>>? = null,
    public val businessProcessName: Output<String>? = null,
    public val businessProcessStages: Output<Map<String, BusinessProcessStageArgs>>? = null,
    public val description: Output<String>? = null,
    public val identifier: Output<BusinessProcessIdentifierArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val spaceName: Output<String>? = null,
    public val tableName: Output<String>? = null,
    public val trackingDataStoreReferenceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.integrationspaces.BusinessProcessArgs> {
    override fun toJava(): com.pulumi.azurenative.integrationspaces.BusinessProcessArgs =
        com.pulumi.azurenative.integrationspaces.BusinessProcessArgs.builder()
            .applicationName(applicationName?.applyValue({ args0 -> args0 }))
            .businessProcessMapping(
                businessProcessMapping?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .businessProcessName(businessProcessName?.applyValue({ args0 -> args0 }))
            .businessProcessStages(
                businessProcessStages?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .identifier(identifier?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .spaceName(spaceName?.applyValue({ args0 -> args0 }))
            .tableName(tableName?.applyValue({ args0 -> args0 }))
            .trackingDataStoreReferenceName(
                trackingDataStoreReferenceName?.applyValue({ args0 ->
                    args0
                }),
            ).build()
}

/**
 * Builder for [BusinessProcessArgs].
 */
@PulumiTagMarker
public class BusinessProcessArgsBuilder internal constructor() {
    private var applicationName: Output<String>? = null

    private var businessProcessMapping: Output<Map<String, BusinessProcessMappingItemArgs>>? = null

    private var businessProcessName: Output<String>? = null

    private var businessProcessStages: Output<Map<String, BusinessProcessStageArgs>>? = null

    private var description: Output<String>? = null

    private var identifier: Output<BusinessProcessIdentifierArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var spaceName: Output<String>? = null

    private var tableName: Output<String>? = null

    private var trackingDataStoreReferenceName: Output<String>? = null

    /**
     * @param value The name of the Application
     */
    @JvmName("nkeeuocyrfbgnpdx")
    public suspend fun applicationName(`value`: Output<String>) {
        this.applicationName = value
    }

    /**
     * @param value The business process mapping.
     */
    @JvmName("yalmvwajtafakywf")
    public suspend
    fun businessProcessMapping(`value`: Output<Map<String, BusinessProcessMappingItemArgs>>) {
        this.businessProcessMapping = value
    }

    /**
     * @param value The name of the business process
     */
    @JvmName("bmveubxsefihbdis")
    public suspend fun businessProcessName(`value`: Output<String>) {
        this.businessProcessName = value
    }

    /**
     * @param value The business process stages.
     */
    @JvmName("wysfiqounoebkdti")
    public suspend fun businessProcessStages(`value`: Output<Map<String, BusinessProcessStageArgs>>) {
        this.businessProcessStages = value
    }

    /**
     * @param value The description of the business process.
     */
    @JvmName("ptqjopcnxtdsbuix")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The business process identifier.
     */
    @JvmName("akfjwnfvfxdwfehb")
    public suspend fun identifier(`value`: Output<BusinessProcessIdentifierArgs>) {
        this.identifier = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("eqrrjluffvlnonkm")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the space
     */
    @JvmName("jkvriagsraplmdbn")
    public suspend fun spaceName(`value`: Output<String>) {
        this.spaceName = value
    }

    /**
     * @param value The table name of the business process.
     */
    @JvmName("emmhamjexvktclmi")
    public suspend fun tableName(`value`: Output<String>) {
        this.tableName = value
    }

    /**
     * @param value The tracking data store reference name.
     */
    @JvmName("jmfxroclfuasjhxw")
    public suspend fun trackingDataStoreReferenceName(`value`: Output<String>) {
        this.trackingDataStoreReferenceName = value
    }

    /**
     * @param value The name of the Application
     */
    @JvmName("hlxfogbfkrncgjrb")
    public suspend fun applicationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationName = mapped
    }

    /**
     * @param value The business process mapping.
     */
    @JvmName("prthyaxreqeesxpb")
    public suspend fun businessProcessMapping(`value`: Map<String, BusinessProcessMappingItemArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.businessProcessMapping = mapped
    }

    /**
     * @param argument The business process mapping.
     */
    @JvmName("dckxlrgdyybgtglh")
    public suspend fun businessProcessMapping(
        vararg
        argument: Pair<String, suspend BusinessProcessMappingItemArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                BusinessProcessMappingItemArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.businessProcessMapping = mapped
    }

    /**
     * @param values The business process mapping.
     */
    @JvmName("bpsiukbbhgkbklab")
    public fun businessProcessMapping(vararg values: Pair<String, BusinessProcessMappingItemArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.businessProcessMapping = mapped
    }

    /**
     * @param value The name of the business process
     */
    @JvmName("oylijpqjnwgirlre")
    public suspend fun businessProcessName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.businessProcessName = mapped
    }

    /**
     * @param value The business process stages.
     */
    @JvmName("htvbgrnoktlvidly")
    public suspend fun businessProcessStages(`value`: Map<String, BusinessProcessStageArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.businessProcessStages = mapped
    }

    /**
     * @param argument The business process stages.
     */
    @JvmName("kuckjnaqxagpqlft")
    public suspend fun businessProcessStages(
        vararg
        argument: Pair<String, suspend BusinessProcessStageArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                BusinessProcessStageArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.businessProcessStages = mapped
    }

    /**
     * @param values The business process stages.
     */
    @JvmName("wcuxosmwdyfnipjw")
    public fun businessProcessStages(vararg values: Pair<String, BusinessProcessStageArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.businessProcessStages = mapped
    }

    /**
     * @param value The description of the business process.
     */
    @JvmName("uhuajeojnpbftnjt")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The business process identifier.
     */
    @JvmName("uykhqxejasaxxwrf")
    public suspend fun identifier(`value`: BusinessProcessIdentifierArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identifier = mapped
    }

    /**
     * @param argument The business process identifier.
     */
    @JvmName("hvdulurfgwxxyvnb")
    public suspend fun identifier(argument: suspend BusinessProcessIdentifierArgsBuilder.() -> Unit) {
        val toBeMapped = BusinessProcessIdentifierArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identifier = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("wtolwxaobyldubay")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the space
     */
    @JvmName("lhqeoetkpenspbvj")
    public suspend fun spaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.spaceName = mapped
    }

    /**
     * @param value The table name of the business process.
     */
    @JvmName("ldxuiyfggtilpxrr")
    public suspend fun tableName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tableName = mapped
    }

    /**
     * @param value The tracking data store reference name.
     */
    @JvmName("ppijwerhchuutdvo")
    public suspend fun trackingDataStoreReferenceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trackingDataStoreReferenceName = mapped
    }

    internal fun build(): BusinessProcessArgs = BusinessProcessArgs(
        applicationName = applicationName,
        businessProcessMapping = businessProcessMapping,
        businessProcessName = businessProcessName,
        businessProcessStages = businessProcessStages,
        description = description,
        identifier = identifier,
        resourceGroupName = resourceGroupName,
        spaceName = spaceName,
        tableName = tableName,
        trackingDataStoreReferenceName = trackingDataStoreReferenceName,
    )
}
