@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.integrationspaces.kotlin

import com.pulumi.azurenative.integrationspaces.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.integrationspaces.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [InfrastructureResource].
 */
@PulumiTagMarker
public class InfrastructureResourceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: InfrastructureResourceArgs = InfrastructureResourceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend InfrastructureResourceArgsBuilder.() -> Unit) {
        val builder = InfrastructureResourceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): InfrastructureResource {
        val builtJavaResource =
            com.pulumi.azurenative.integrationspaces.InfrastructureResource(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return InfrastructureResource(builtJavaResource)
    }
}

/**
 * An infrastructure resource under Space.
 * Azure REST API version: 2023-11-14-preview.
 * ## Example Usage
 * ### CreateOrUpdateInfrastructureResource
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var infrastructureResource = new AzureNative.IntegrationSpaces.InfrastructureResource("infrastructureResource", new()
 *     {
 *         InfrastructureResourceName = "InfrastructureResource1",
 *         ResourceGroupName = "testrg",
 *         ResourceId = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/testrg/providers/Microsoft.ApiManagement/service/APIM1",
 *         ResourceType = "Microsoft.ApiManagement/service",
 *         SpaceName = "Space1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/integrationspaces/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := integrationspaces.NewInfrastructureResource(ctx, "infrastructureResource", &integrationspaces.InfrastructureResourceArgs{
 * 			InfrastructureResourceName: pulumi.String("InfrastructureResource1"),
 * 			ResourceGroupName:          pulumi.String("testrg"),
 * 			ResourceId:                 pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/testrg/providers/Microsoft.ApiManagement/service/APIM1"),
 * 			ResourceType:               pulumi.String("Microsoft.ApiManagement/service"),
 * 			SpaceName:                  pulumi.String("Space1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.integrationspaces.InfrastructureResource;
 * import com.pulumi.azurenative.integrationspaces.InfrastructureResourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var infrastructureResource = new InfrastructureResource("infrastructureResource", InfrastructureResourceArgs.builder()
 *             .infrastructureResourceName("InfrastructureResource1")
 *             .resourceGroupName("testrg")
 *             .resourceId("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/testrg/providers/Microsoft.ApiManagement/service/APIM1")
 *             .resourceType("Microsoft.ApiManagement/service")
 *             .spaceName("Space1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:integrationspaces:InfrastructureResource InfrastructureResource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IntegrationSpaces/spaces/{spaceName}/infrastructureResources/{infrastructureResourceName}
 * ```
 */
public class InfrastructureResource internal constructor(
    override val javaResource: com.pulumi.azurenative.integrationspaces.InfrastructureResource,
) : KotlinCustomResource(javaResource, InfrastructureResourceMapper) {
    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The status of the last operation.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The id of the infrastructure resource.
     */
    public val resourceId: Output<String>
        get() = javaResource.resourceId().applyValue({ args0 -> args0 })

    /**
     * The type of the infrastructure resource.
     */
    public val resourceType: Output<String>
        get() = javaResource.resourceType().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object InfrastructureResourceMapper : ResourceMapper<InfrastructureResource> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.integrationspaces.InfrastructureResource::class == javaResource::class

    override fun map(javaResource: Resource): InfrastructureResource =
        InfrastructureResource(
            javaResource as
                com.pulumi.azurenative.integrationspaces.InfrastructureResource,
        )
}

/**
 * @see [InfrastructureResource].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [InfrastructureResource].
 */
public suspend fun infrastructureResource(
    name: String,
    block: suspend InfrastructureResourceResourceBuilder.() -> Unit,
): InfrastructureResource {
    val builder = InfrastructureResourceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [InfrastructureResource].
 * @param name The _unique_ name of the resulting resource.
 */
public fun infrastructureResource(name: String): InfrastructureResource {
    val builder = InfrastructureResourceResourceBuilder()
    builder.name(name)
    return builder.build()
}
