@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.integrationspaces.kotlin

import com.pulumi.azurenative.integrationspaces.InfrastructureResourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * An infrastructure resource under Space.
 * Azure REST API version: 2023-11-14-preview.
 * ## Example Usage
 * ### CreateOrUpdateInfrastructureResource
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var infrastructureResource = new AzureNative.IntegrationSpaces.InfrastructureResource("infrastructureResource", new()
 *     {
 *         InfrastructureResourceName = "InfrastructureResource1",
 *         ResourceGroupName = "testrg",
 *         ResourceId = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/testrg/providers/Microsoft.ApiManagement/service/APIM1",
 *         ResourceType = "Microsoft.ApiManagement/service",
 *         SpaceName = "Space1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/integrationspaces/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := integrationspaces.NewInfrastructureResource(ctx, "infrastructureResource", &integrationspaces.InfrastructureResourceArgs{
 * 			InfrastructureResourceName: pulumi.String("InfrastructureResource1"),
 * 			ResourceGroupName:          pulumi.String("testrg"),
 * 			ResourceId:                 pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/testrg/providers/Microsoft.ApiManagement/service/APIM1"),
 * 			ResourceType:               pulumi.String("Microsoft.ApiManagement/service"),
 * 			SpaceName:                  pulumi.String("Space1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.integrationspaces.InfrastructureResource;
 * import com.pulumi.azurenative.integrationspaces.InfrastructureResourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var infrastructureResource = new InfrastructureResource("infrastructureResource", InfrastructureResourceArgs.builder()
 *             .infrastructureResourceName("InfrastructureResource1")
 *             .resourceGroupName("testrg")
 *             .resourceId("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/testrg/providers/Microsoft.ApiManagement/service/APIM1")
 *             .resourceType("Microsoft.ApiManagement/service")
 *             .spaceName("Space1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:integrationspaces:InfrastructureResource InfrastructureResource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IntegrationSpaces/spaces/{spaceName}/infrastructureResources/{infrastructureResourceName}
 * ```
 * @property infrastructureResourceName The name of the infrastructure resource in the space.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property resourceId The id of the infrastructure resource.
 * @property resourceType The type of the infrastructure resource.
 * @property spaceName The name of the space
 */
public data class InfrastructureResourceArgs(
    public val infrastructureResourceName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val resourceId: Output<String>? = null,
    public val resourceType: Output<String>? = null,
    public val spaceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.integrationspaces.InfrastructureResourceArgs> {
    override fun toJava(): com.pulumi.azurenative.integrationspaces.InfrastructureResourceArgs =
        com.pulumi.azurenative.integrationspaces.InfrastructureResourceArgs.builder()
            .infrastructureResourceName(infrastructureResourceName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .resourceId(resourceId?.applyValue({ args0 -> args0 }))
            .resourceType(resourceType?.applyValue({ args0 -> args0 }))
            .spaceName(spaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InfrastructureResourceArgs].
 */
@PulumiTagMarker
public class InfrastructureResourceArgsBuilder internal constructor() {
    private var infrastructureResourceName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var resourceId: Output<String>? = null

    private var resourceType: Output<String>? = null

    private var spaceName: Output<String>? = null

    /**
     * @param value The name of the infrastructure resource in the space.
     */
    @JvmName("rjbwspkbamtgaqwk")
    public suspend fun infrastructureResourceName(`value`: Output<String>) {
        this.infrastructureResourceName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ioxmefttnrhhqipl")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The id of the infrastructure resource.
     */
    @JvmName("xambyucctrgsbaga")
    public suspend fun resourceId(`value`: Output<String>) {
        this.resourceId = value
    }

    /**
     * @param value The type of the infrastructure resource.
     */
    @JvmName("rifvruhoaxweykja")
    public suspend fun resourceType(`value`: Output<String>) {
        this.resourceType = value
    }

    /**
     * @param value The name of the space
     */
    @JvmName("hqyloxahkmfebovn")
    public suspend fun spaceName(`value`: Output<String>) {
        this.spaceName = value
    }

    /**
     * @param value The name of the infrastructure resource in the space.
     */
    @JvmName("cvfynruwoxtuiqav")
    public suspend fun infrastructureResourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.infrastructureResourceName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("firuenmkkcvvfogs")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The id of the infrastructure resource.
     */
    @JvmName("yjopoqwqicfexnya")
    public suspend fun resourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceId = mapped
    }

    /**
     * @param value The type of the infrastructure resource.
     */
    @JvmName("dafvwiitwajytots")
    public suspend fun resourceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceType = mapped
    }

    /**
     * @param value The name of the space
     */
    @JvmName("vjxfippelrtyeowc")
    public suspend fun spaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.spaceName = mapped
    }

    internal fun build(): InfrastructureResourceArgs = InfrastructureResourceArgs(
        infrastructureResourceName = infrastructureResourceName,
        resourceGroupName = resourceGroupName,
        resourceId = resourceId,
        resourceType = resourceType,
        spaceName = spaceName,
    )
}
