@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.integrationspaces.kotlin.inputs

import com.pulumi.azurenative.integrationspaces.inputs.GetBusinessProcessPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property applicationName The name of the Application
 * @property businessProcessName The name of the business process
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property spaceName The name of the space
 */
public data class GetBusinessProcessPlainArgs(
    public val applicationName: String,
    public val businessProcessName: String,
    public val resourceGroupName: String,
    public val spaceName: String,
) : ConvertibleToJava<com.pulumi.azurenative.integrationspaces.inputs.GetBusinessProcessPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.integrationspaces.inputs.GetBusinessProcessPlainArgs =
        com.pulumi.azurenative.integrationspaces.inputs.GetBusinessProcessPlainArgs.builder()
            .applicationName(applicationName.let({ args0 -> args0 }))
            .businessProcessName(businessProcessName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .spaceName(spaceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetBusinessProcessPlainArgs].
 */
@PulumiTagMarker
public class GetBusinessProcessPlainArgsBuilder internal constructor() {
    private var applicationName: String? = null

    private var businessProcessName: String? = null

    private var resourceGroupName: String? = null

    private var spaceName: String? = null

    /**
     * @param value The name of the Application
     */
    @JvmName("ywbphrkbxuwndygc")
    public suspend fun applicationName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.applicationName = mapped
    }

    /**
     * @param value The name of the business process
     */
    @JvmName("ngxahxfuuinjykgg")
    public suspend fun businessProcessName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.businessProcessName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("seguxwdvuwjxpyow")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the space
     */
    @JvmName("qitijrhvhakudjkh")
    public suspend fun spaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.spaceName = mapped
    }

    internal fun build(): GetBusinessProcessPlainArgs = GetBusinessProcessPlainArgs(
        applicationName = applicationName ?: throw PulumiNullFieldException("applicationName"),
        businessProcessName = businessProcessName ?: throw PulumiNullFieldException("businessProcessName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        spaceName = spaceName ?: throw PulumiNullFieldException("spaceName"),
    )
}
