@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.integrationspaces.kotlin.inputs

import com.pulumi.azurenative.integrationspaces.inputs.GetInfrastructureResourcePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property infrastructureResourceName The name of the infrastructure resource in the space.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property spaceName The name of the space
 */
public data class GetInfrastructureResourcePlainArgs(
    public val infrastructureResourceName: String,
    public val resourceGroupName: String,
    public val spaceName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.integrationspaces.inputs.GetInfrastructureResourcePlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.integrationspaces.inputs.GetInfrastructureResourcePlainArgs =
        com.pulumi.azurenative.integrationspaces.inputs.GetInfrastructureResourcePlainArgs.builder()
            .infrastructureResourceName(infrastructureResourceName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .spaceName(spaceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetInfrastructureResourcePlainArgs].
 */
@PulumiTagMarker
public class GetInfrastructureResourcePlainArgsBuilder internal constructor() {
    private var infrastructureResourceName: String? = null

    private var resourceGroupName: String? = null

    private var spaceName: String? = null

    /**
     * @param value The name of the infrastructure resource in the space.
     */
    @JvmName("hpcniiodudmvjgdk")
    public suspend fun infrastructureResourceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.infrastructureResourceName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("enhyjmjexihcpyxk")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the space
     */
    @JvmName("smbidxkscefjueyl")
    public suspend fun spaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.spaceName = mapped
    }

    internal fun build(): GetInfrastructureResourcePlainArgs = GetInfrastructureResourcePlainArgs(
        infrastructureResourceName = infrastructureResourceName ?: throw
            PulumiNullFieldException("infrastructureResourceName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        spaceName = spaceName ?: throw PulumiNullFieldException("spaceName"),
    )
}
