@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.intune.kotlin

import com.pulumi.azurenative.intune.IoMAMPolicyByNameArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * iOS Policy entity for Intune MAM.
 * Azure REST API version: 2015-01-14-preview. Prior API version in Azure Native 1.x: 2015-01-14-preview.
 * Other available API versions: 2015-01-14-privatepreview.
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:intune:IoMAMPolicyByName myresource1 /providers/Microsoft.Intune/locations/{hostName}/iosPolicies/{policyName}
 * ```
 * @property accessRecheckOfflineTimeout
 * @property accessRecheckOnlineTimeout
 * @property appSharingFromLevel
 * @property appSharingToLevel
 * @property authentication
 * @property clipboardSharingLevel
 * @property dataBackup
 * @property description
 * @property deviceCompliance
 * @property fileEncryptionLevel
 * @property fileSharingSaveAs
 * @property friendlyName
 * @property hostName Location hostName for the tenant
 * @property location Resource Location
 * @property managedBrowser
 * @property offlineWipeTimeout
 * @property pin
 * @property pinNumRetry
 * @property policyName Unique name for the policy
 * @property tags Resource Tags
 * @property touchId
 */
public data class IoMAMPolicyByNameArgs(
    public val accessRecheckOfflineTimeout: Output<String>? = null,
    public val accessRecheckOnlineTimeout: Output<String>? = null,
    public val appSharingFromLevel: Output<String>? = null,
    public val appSharingToLevel: Output<String>? = null,
    public val authentication: Output<String>? = null,
    public val clipboardSharingLevel: Output<String>? = null,
    public val dataBackup: Output<String>? = null,
    public val description: Output<String>? = null,
    public val deviceCompliance: Output<String>? = null,
    public val fileEncryptionLevel: Output<String>? = null,
    public val fileSharingSaveAs: Output<String>? = null,
    public val friendlyName: Output<String>? = null,
    public val hostName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val managedBrowser: Output<String>? = null,
    public val offlineWipeTimeout: Output<String>? = null,
    public val pin: Output<String>? = null,
    public val pinNumRetry: Output<Int>? = null,
    public val policyName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val touchId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.intune.IoMAMPolicyByNameArgs> {
    override fun toJava(): com.pulumi.azurenative.intune.IoMAMPolicyByNameArgs =
        com.pulumi.azurenative.intune.IoMAMPolicyByNameArgs.builder()
            .accessRecheckOfflineTimeout(accessRecheckOfflineTimeout?.applyValue({ args0 -> args0 }))
            .accessRecheckOnlineTimeout(accessRecheckOnlineTimeout?.applyValue({ args0 -> args0 }))
            .appSharingFromLevel(appSharingFromLevel?.applyValue({ args0 -> args0 }))
            .appSharingToLevel(appSharingToLevel?.applyValue({ args0 -> args0 }))
            .authentication(authentication?.applyValue({ args0 -> args0 }))
            .clipboardSharingLevel(clipboardSharingLevel?.applyValue({ args0 -> args0 }))
            .dataBackup(dataBackup?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .deviceCompliance(deviceCompliance?.applyValue({ args0 -> args0 }))
            .fileEncryptionLevel(fileEncryptionLevel?.applyValue({ args0 -> args0 }))
            .fileSharingSaveAs(fileSharingSaveAs?.applyValue({ args0 -> args0 }))
            .friendlyName(friendlyName?.applyValue({ args0 -> args0 }))
            .hostName(hostName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .managedBrowser(managedBrowser?.applyValue({ args0 -> args0 }))
            .offlineWipeTimeout(offlineWipeTimeout?.applyValue({ args0 -> args0 }))
            .pin(pin?.applyValue({ args0 -> args0 }))
            .pinNumRetry(pinNumRetry?.applyValue({ args0 -> args0 }))
            .policyName(policyName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .touchId(touchId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IoMAMPolicyByNameArgs].
 */
@PulumiTagMarker
public class IoMAMPolicyByNameArgsBuilder internal constructor() {
    private var accessRecheckOfflineTimeout: Output<String>? = null

    private var accessRecheckOnlineTimeout: Output<String>? = null

    private var appSharingFromLevel: Output<String>? = null

    private var appSharingToLevel: Output<String>? = null

    private var authentication: Output<String>? = null

    private var clipboardSharingLevel: Output<String>? = null

    private var dataBackup: Output<String>? = null

    private var description: Output<String>? = null

    private var deviceCompliance: Output<String>? = null

    private var fileEncryptionLevel: Output<String>? = null

    private var fileSharingSaveAs: Output<String>? = null

    private var friendlyName: Output<String>? = null

    private var hostName: Output<String>? = null

    private var location: Output<String>? = null

    private var managedBrowser: Output<String>? = null

    private var offlineWipeTimeout: Output<String>? = null

    private var pin: Output<String>? = null

    private var pinNumRetry: Output<Int>? = null

    private var policyName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var touchId: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("kgghpbseqhucbuil")
    public suspend fun accessRecheckOfflineTimeout(`value`: Output<String>) {
        this.accessRecheckOfflineTimeout = value
    }

    /**
     * @param value
     */
    @JvmName("rmuyxuwhraqblmhb")
    public suspend fun accessRecheckOnlineTimeout(`value`: Output<String>) {
        this.accessRecheckOnlineTimeout = value
    }

    /**
     * @param value
     */
    @JvmName("hjxmcxoydjvrdonh")
    public suspend fun appSharingFromLevel(`value`: Output<String>) {
        this.appSharingFromLevel = value
    }

    /**
     * @param value
     */
    @JvmName("hrvucxgygenrtbym")
    public suspend fun appSharingToLevel(`value`: Output<String>) {
        this.appSharingToLevel = value
    }

    /**
     * @param value
     */
    @JvmName("hfilpkawcnxntlha")
    public suspend fun authentication(`value`: Output<String>) {
        this.authentication = value
    }

    /**
     * @param value
     */
    @JvmName("ulpskwhtackcglsg")
    public suspend fun clipboardSharingLevel(`value`: Output<String>) {
        this.clipboardSharingLevel = value
    }

    /**
     * @param value
     */
    @JvmName("pxyhbwiabkmfexam")
    public suspend fun dataBackup(`value`: Output<String>) {
        this.dataBackup = value
    }

    /**
     * @param value
     */
    @JvmName("jpwtbeussyrmnpob")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value
     */
    @JvmName("lupxnydhwyrubrpo")
    public suspend fun deviceCompliance(`value`: Output<String>) {
        this.deviceCompliance = value
    }

    /**
     * @param value
     */
    @JvmName("knyffgaupcqbofup")
    public suspend fun fileEncryptionLevel(`value`: Output<String>) {
        this.fileEncryptionLevel = value
    }

    /**
     * @param value
     */
    @JvmName("vvcnsfsbyfkxtgmd")
    public suspend fun fileSharingSaveAs(`value`: Output<String>) {
        this.fileSharingSaveAs = value
    }

    /**
     * @param value
     */
    @JvmName("cvpmkxpilymausap")
    public suspend fun friendlyName(`value`: Output<String>) {
        this.friendlyName = value
    }

    /**
     * @param value Location hostName for the tenant
     */
    @JvmName("lgtbktrlbfvebpls")
    public suspend fun hostName(`value`: Output<String>) {
        this.hostName = value
    }

    /**
     * @param value Resource Location
     */
    @JvmName("pxajamqgxthfuxdm")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value
     */
    @JvmName("sklnggjubocdcsnh")
    public suspend fun managedBrowser(`value`: Output<String>) {
        this.managedBrowser = value
    }

    /**
     * @param value
     */
    @JvmName("kykhtefmumevbfyl")
    public suspend fun offlineWipeTimeout(`value`: Output<String>) {
        this.offlineWipeTimeout = value
    }

    /**
     * @param value
     */
    @JvmName("pumilkaarfcshgno")
    public suspend fun pin(`value`: Output<String>) {
        this.pin = value
    }

    /**
     * @param value
     */
    @JvmName("bhmwrolnvntyptci")
    public suspend fun pinNumRetry(`value`: Output<Int>) {
        this.pinNumRetry = value
    }

    /**
     * @param value Unique name for the policy
     */
    @JvmName("ieanuroijtklypxb")
    public suspend fun policyName(`value`: Output<String>) {
        this.policyName = value
    }

    /**
     * @param value Resource Tags
     */
    @JvmName("kxebntawwbbmqkun")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value
     */
    @JvmName("nrgxefyinmscwkdf")
    public suspend fun touchId(`value`: Output<String>) {
        this.touchId = value
    }

    /**
     * @param value
     */
    @JvmName("vmptopcgwetvbiht")
    public suspend fun accessRecheckOfflineTimeout(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessRecheckOfflineTimeout = mapped
    }

    /**
     * @param value
     */
    @JvmName("qytkvwhmagdhqskx")
    public suspend fun accessRecheckOnlineTimeout(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessRecheckOnlineTimeout = mapped
    }

    /**
     * @param value
     */
    @JvmName("xemgoxqxovmmfxwu")
    public suspend fun appSharingFromLevel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.appSharingFromLevel = mapped
    }

    /**
     * @param value
     */
    @JvmName("wehcynckbrirojeq")
    public suspend fun appSharingToLevel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.appSharingToLevel = mapped
    }

    /**
     * @param value
     */
    @JvmName("fidscamnevuvasqa")
    public suspend fun authentication(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authentication = mapped
    }

    /**
     * @param value
     */
    @JvmName("tvffytelwkumfniq")
    public suspend fun clipboardSharingLevel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clipboardSharingLevel = mapped
    }

    /**
     * @param value
     */
    @JvmName("vakhdutoltokfhgl")
    public suspend fun dataBackup(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataBackup = mapped
    }

    /**
     * @param value
     */
    @JvmName("baecgylxipdrbivr")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value
     */
    @JvmName("viqjjgvynhjtaciq")
    public suspend fun deviceCompliance(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deviceCompliance = mapped
    }

    /**
     * @param value
     */
    @JvmName("opmbqgdrobneufog")
    public suspend fun fileEncryptionLevel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fileEncryptionLevel = mapped
    }

    /**
     * @param value
     */
    @JvmName("ssklrsaodnbyswwp")
    public suspend fun fileSharingSaveAs(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fileSharingSaveAs = mapped
    }

    /**
     * @param value
     */
    @JvmName("tuuestrrxpgmdxlu")
    public suspend fun friendlyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.friendlyName = mapped
    }

    /**
     * @param value Location hostName for the tenant
     */
    @JvmName("askvsvssfbcbcinb")
    public suspend fun hostName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostName = mapped
    }

    /**
     * @param value Resource Location
     */
    @JvmName("mohdkoxycscyawwn")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value
     */
    @JvmName("aujgkavpclsspwbd")
    public suspend fun managedBrowser(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managedBrowser = mapped
    }

    /**
     * @param value
     */
    @JvmName("vwiuwbthmnndutsb")
    public suspend fun offlineWipeTimeout(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.offlineWipeTimeout = mapped
    }

    /**
     * @param value
     */
    @JvmName("fccpocsuvnqqduqc")
    public suspend fun pin(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pin = mapped
    }

    /**
     * @param value
     */
    @JvmName("egptqjiyucdxmefn")
    public suspend fun pinNumRetry(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pinNumRetry = mapped
    }

    /**
     * @param value Unique name for the policy
     */
    @JvmName("jmhwxyiqqsnthjty")
    public suspend fun policyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyName = mapped
    }

    /**
     * @param value Resource Tags
     */
    @JvmName("qwmdxnbpmgficebb")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource Tags
     */
    @JvmName("gldcblbhefewleyf")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value
     */
    @JvmName("osfpyjoojwtnnqau")
    public suspend fun touchId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.touchId = mapped
    }

    internal fun build(): IoMAMPolicyByNameArgs = IoMAMPolicyByNameArgs(
        accessRecheckOfflineTimeout = accessRecheckOfflineTimeout,
        accessRecheckOnlineTimeout = accessRecheckOnlineTimeout,
        appSharingFromLevel = appSharingFromLevel,
        appSharingToLevel = appSharingToLevel,
        authentication = authentication,
        clipboardSharingLevel = clipboardSharingLevel,
        dataBackup = dataBackup,
        description = description,
        deviceCompliance = deviceCompliance,
        fileEncryptionLevel = fileEncryptionLevel,
        fileSharingSaveAs = fileSharingSaveAs,
        friendlyName = friendlyName,
        hostName = hostName,
        location = location,
        managedBrowser = managedBrowser,
        offlineWipeTimeout = offlineWipeTimeout,
        pin = pin,
        pinNumRetry = pinNumRetry,
        policyName = policyName,
        tags = tags,
        touchId = touchId,
    )
}
