@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotcentral.kotlin

import com.pulumi.azurenative.iotcentral.AppArgs.builder
import com.pulumi.azurenative.iotcentral.kotlin.inputs.AppSkuInfoArgs
import com.pulumi.azurenative.iotcentral.kotlin.inputs.AppSkuInfoArgsBuilder
import com.pulumi.azurenative.iotcentral.kotlin.inputs.SystemAssignedServiceIdentityArgs
import com.pulumi.azurenative.iotcentral.kotlin.inputs.SystemAssignedServiceIdentityArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The IoT Central application.
 * Azure REST API version: 2021-06-01. Prior API version in Azure Native 1.x: 2021-06-01.
 * Other available API versions: 2018-09-01, 2021-11-01-preview.
 * ## Example Usage
 * ### Apps_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var app = new AzureNative.IoTCentral.App("app", new()
 *     {
 *         DisplayName = "My IoT Central App",
 *         Identity = new AzureNative.IoTCentral.Inputs.SystemAssignedServiceIdentityArgs
 *         {
 *             Type = "SystemAssigned",
 *         },
 *         Location = "westus",
 *         ResourceGroupName = "resRg",
 *         ResourceName = "myIoTCentralApp",
 *         Sku = new AzureNative.IoTCentral.Inputs.AppSkuInfoArgs
 *         {
 *             Name = "ST2",
 *         },
 *         Subdomain = "my-iot-central-app",
 *         Template = "iotc-pnp-preview@1.0.0",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/iotcentral/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := iotcentral.NewApp(ctx, "app", &iotcentral.AppArgs{
 * 			DisplayName: pulumi.String("My IoT Central App"),
 * 			Identity: &iotcentral.SystemAssignedServiceIdentityArgs{
 * 				Type: pulumi.String("SystemAssigned"),
 * 			},
 * 			Location:          pulumi.String("westus"),
 * 			ResourceGroupName: pulumi.String("resRg"),
 * 			ResourceName:      pulumi.String("myIoTCentralApp"),
 * 			Sku: &iotcentral.AppSkuInfoArgs{
 * 				Name: pulumi.String("ST2"),
 * 			},
 * 			Subdomain: pulumi.String("my-iot-central-app"),
 * 			Template:  pulumi.String("iotc-pnp-preview@1.0.0"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.iotcentral.App;
 * import com.pulumi.azurenative.iotcentral.AppArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var app = new App("app", AppArgs.builder()
 *             .displayName("My IoT Central App")
 *             .identity(Map.of("type", "SystemAssigned"))
 *             .location("westus")
 *             .resourceGroupName("resRg")
 *             .resourceName("myIoTCentralApp")
 *             .sku(Map.of("name", "ST2"))
 *             .subdomain("my-iot-central-app")
 *             .template("iotc-pnp-preview@1.0.0")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:iotcentral:App myIoTCentralApp /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IoTCentral/iotApps/{resourceName}
 * ```
 * @property displayName The display name of the application.
 * @property identity The managed identities for the IoT Central application.
 * @property location The resource location.
 * @property resourceGroupName The name of the resource group that contains the IoT Central application.
 * @property resourceName The ARM resource name of the IoT Central application.
 * @property sku A valid instance SKU.
 * @property subdomain The subdomain of the application.
 * @property tags The resource tags.
 * @property template The ID of the application template, which is a blueprint that defines the characteristics and behaviors of an application. Optional; if not specified, defaults to a blank blueprint and allows the application to be defined from scratch.
 */
public data class AppArgs(
    public val displayName: Output<String>? = null,
    public val identity: Output<SystemAssignedServiceIdentityArgs>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val resourceName: Output<String>? = null,
    public val sku: Output<AppSkuInfoArgs>? = null,
    public val subdomain: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val template: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.iotcentral.AppArgs> {
    override fun toJava(): com.pulumi.azurenative.iotcentral.AppArgs =
        com.pulumi.azurenative.iotcentral.AppArgs.builder()
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .resourceName(resourceName?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .subdomain(subdomain?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .template(template?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AppArgs].
 */
@PulumiTagMarker
public class AppArgsBuilder internal constructor() {
    private var displayName: Output<String>? = null

    private var identity: Output<SystemAssignedServiceIdentityArgs>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var resourceName: Output<String>? = null

    private var sku: Output<AppSkuInfoArgs>? = null

    private var subdomain: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var template: Output<String>? = null

    /**
     * @param value The display name of the application.
     */
    @JvmName("bftitaajnlvjaqll")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value The managed identities for the IoT Central application.
     */
    @JvmName("jscjfmaubewswbko")
    public suspend fun identity(`value`: Output<SystemAssignedServiceIdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value The resource location.
     */
    @JvmName("trjniesowomjyimv")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group that contains the IoT Central application.
     */
    @JvmName("ylppfsespancqfaf")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The ARM resource name of the IoT Central application.
     */
    @JvmName("hsqhaxkyaowdmnsf")
    public suspend fun resourceName(`value`: Output<String>) {
        this.resourceName = value
    }

    /**
     * @param value A valid instance SKU.
     */
    @JvmName("wrcescgpntfggrdk")
    public suspend fun sku(`value`: Output<AppSkuInfoArgs>) {
        this.sku = value
    }

    /**
     * @param value The subdomain of the application.
     */
    @JvmName("toqnqrjmlmphbfwb")
    public suspend fun subdomain(`value`: Output<String>) {
        this.subdomain = value
    }

    /**
     * @param value The resource tags.
     */
    @JvmName("rlvfjiraeqyonbpq")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The ID of the application template, which is a blueprint that defines the characteristics and behaviors of an application. Optional; if not specified, defaults to a blank blueprint and allows the application to be defined from scratch.
     */
    @JvmName("xrlqjeflwmxdkxka")
    public suspend fun template(`value`: Output<String>) {
        this.template = value
    }

    /**
     * @param value The display name of the application.
     */
    @JvmName("vxejulxgtejjoqgm")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value The managed identities for the IoT Central application.
     */
    @JvmName("nyvgebpssydgkffm")
    public suspend fun identity(`value`: SystemAssignedServiceIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument The managed identities for the IoT Central application.
     */
    @JvmName("mivexdcyffuvdxmg")
    public suspend
    fun identity(argument: suspend SystemAssignedServiceIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = SystemAssignedServiceIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value The resource location.
     */
    @JvmName("eyyujwmfjncuhiys")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group that contains the IoT Central application.
     */
    @JvmName("wlrjsbonrqqcpjkx")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The ARM resource name of the IoT Central application.
     */
    @JvmName("mhyubfxfmseyidet")
    public suspend fun resourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceName = mapped
    }

    /**
     * @param value A valid instance SKU.
     */
    @JvmName("nuqlqeoytamovdiv")
    public suspend fun sku(`value`: AppSkuInfoArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument A valid instance SKU.
     */
    @JvmName("ndwmobnmrytumeyb")
    public suspend fun sku(argument: suspend AppSkuInfoArgsBuilder.() -> Unit) {
        val toBeMapped = AppSkuInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value The subdomain of the application.
     */
    @JvmName("otpjfwwcqydeliwf")
    public suspend fun subdomain(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subdomain = mapped
    }

    /**
     * @param value The resource tags.
     */
    @JvmName("xejsgaspnsptpwbf")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The resource tags.
     */
    @JvmName("daxcgrrixehmlpqa")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The ID of the application template, which is a blueprint that defines the characteristics and behaviors of an application. Optional; if not specified, defaults to a blank blueprint and allows the application to be defined from scratch.
     */
    @JvmName("eendkxayeqybyjyo")
    public suspend fun template(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.template = mapped
    }

    internal fun build(): AppArgs = AppArgs(
        displayName = displayName,
        identity = identity,
        location = location,
        resourceGroupName = resourceGroupName,
        resourceName = resourceName,
        sku = sku,
        subdomain = subdomain,
        tags = tags,
        template = template,
    )
}
