@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotcentral.kotlin

import com.pulumi.azurenative.iotcentral.PrivateEndpointConnectionArgs.builder
import com.pulumi.azurenative.iotcentral.kotlin.inputs.PrivateLinkServiceConnectionStateArgs
import com.pulumi.azurenative.iotcentral.kotlin.inputs.PrivateLinkServiceConnectionStateArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The private endpoint connection resource.
 * Azure REST API version: 2021-11-01-preview. Prior API version in Azure Native 1.x: 2021-11-01-preview.
 * ## Example Usage
 * ### PrivateEndpointConnections_Update
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var privateEndpointConnection = new AzureNative.IoTCentral.PrivateEndpointConnection("privateEndpointConnection", new()
 *     {
 *         PrivateEndpointConnectionName = "myIoTCentralAppEndpoint",
 *         PrivateLinkServiceConnectionState = new AzureNative.IoTCentral.Inputs.PrivateLinkServiceConnectionStateArgs
 *         {
 *             ActionsRequired = "None",
 *             Description = "Auto-approved",
 *             Status = "Approved",
 *         },
 *         ResourceGroupName = "resRg",
 *         ResourceName = "myIoTCentralApp",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/iotcentral/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := iotcentral.NewPrivateEndpointConnection(ctx, "privateEndpointConnection", &iotcentral.PrivateEndpointConnectionArgs{
 * 			PrivateEndpointConnectionName: pulumi.String("myIoTCentralAppEndpoint"),
 * 			PrivateLinkServiceConnectionState: &iotcentral.PrivateLinkServiceConnectionStateArgs{
 * 				ActionsRequired: pulumi.String("None"),
 * 				Description:     pulumi.String("Auto-approved"),
 * 				Status:          pulumi.String("Approved"),
 * 			},
 * 			ResourceGroupName: pulumi.String("resRg"),
 * 			ResourceName:      pulumi.String("myIoTCentralApp"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.iotcentral.PrivateEndpointConnection;
 * import com.pulumi.azurenative.iotcentral.PrivateEndpointConnectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var privateEndpointConnection = new PrivateEndpointConnection("privateEndpointConnection", PrivateEndpointConnectionArgs.builder()
 *             .privateEndpointConnectionName("myIoTCentralAppEndpoint")
 *             .privateLinkServiceConnectionState(Map.ofEntries(
 *                 Map.entry("actionsRequired", "None"),
 *                 Map.entry("description", "Auto-approved"),
 *                 Map.entry("status", "Approved")
 *             ))
 *             .resourceGroupName("resRg")
 *             .resourceName("myIoTCentralApp")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:iotcentral:PrivateEndpointConnection myIoTCentralAppEndpoint.a791c6b5-874d-4f03-9092-718490d33770 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IoTCentral/iotApps/{resourceName}/privateEndpointConnections/{privateEndpointConnectionName}
 * ```
 * @property privateEndpointConnectionName The private endpoint connection name.
 * @property privateLinkServiceConnectionState A collection of information about the state of the connection between service consumer and provider.
 * @property resourceGroupName The name of the resource group that contains the IoT Central application.
 * @property resourceName The ARM resource name of the IoT Central application.
 */
public data class PrivateEndpointConnectionArgs(
    public val privateEndpointConnectionName: Output<String>? = null,
    public val privateLinkServiceConnectionState: Output<PrivateLinkServiceConnectionStateArgs>? =
        null,
    public val resourceGroupName: Output<String>? = null,
    public val resourceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.iotcentral.PrivateEndpointConnectionArgs> {
    override fun toJava(): com.pulumi.azurenative.iotcentral.PrivateEndpointConnectionArgs =
        com.pulumi.azurenative.iotcentral.PrivateEndpointConnectionArgs.builder()
            .privateEndpointConnectionName(privateEndpointConnectionName?.applyValue({ args0 -> args0 }))
            .privateLinkServiceConnectionState(
                privateLinkServiceConnectionState?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .resourceName(resourceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PrivateEndpointConnectionArgs].
 */
@PulumiTagMarker
public class PrivateEndpointConnectionArgsBuilder internal constructor() {
    private var privateEndpointConnectionName: Output<String>? = null

    private var privateLinkServiceConnectionState: Output<PrivateLinkServiceConnectionStateArgs>? =
        null

    private var resourceGroupName: Output<String>? = null

    private var resourceName: Output<String>? = null

    /**
     * @param value The private endpoint connection name.
     */
    @JvmName("vtrlwhydmdrahpya")
    public suspend fun privateEndpointConnectionName(`value`: Output<String>) {
        this.privateEndpointConnectionName = value
    }

    /**
     * @param value A collection of information about the state of the connection between service consumer and provider.
     */
    @JvmName("jhbuktuxvcgenndx")
    public suspend
    fun privateLinkServiceConnectionState(`value`: Output<PrivateLinkServiceConnectionStateArgs>) {
        this.privateLinkServiceConnectionState = value
    }

    /**
     * @param value The name of the resource group that contains the IoT Central application.
     */
    @JvmName("aalmdfcutujwiwlq")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The ARM resource name of the IoT Central application.
     */
    @JvmName("fickutscfghebvcw")
    public suspend fun resourceName(`value`: Output<String>) {
        this.resourceName = value
    }

    /**
     * @param value The private endpoint connection name.
     */
    @JvmName("eiauiyhibdugwtrc")
    public suspend fun privateEndpointConnectionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateEndpointConnectionName = mapped
    }

    /**
     * @param value A collection of information about the state of the connection between service consumer and provider.
     */
    @JvmName("yttnlrnuvbwegxwk")
    public suspend
    fun privateLinkServiceConnectionState(`value`: PrivateLinkServiceConnectionStateArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateLinkServiceConnectionState = mapped
    }

    /**
     * @param argument A collection of information about the state of the connection between service consumer and provider.
     */
    @JvmName("oxofivpgbmqqxuch")
    public suspend
    fun privateLinkServiceConnectionState(argument: suspend PrivateLinkServiceConnectionStateArgsBuilder.() -> Unit) {
        val toBeMapped = PrivateLinkServiceConnectionStateArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.privateLinkServiceConnectionState = mapped
    }

    /**
     * @param value The name of the resource group that contains the IoT Central application.
     */
    @JvmName("ialspqnclwotkuhr")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The ARM resource name of the IoT Central application.
     */
    @JvmName("fglkuybduxbitksl")
    public suspend fun resourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceName = mapped
    }

    internal fun build(): PrivateEndpointConnectionArgs = PrivateEndpointConnectionArgs(
        privateEndpointConnectionName = privateEndpointConnectionName,
        privateLinkServiceConnectionState = privateLinkServiceConnectionState,
        resourceGroupName = resourceGroupName,
        resourceName = resourceName,
    )
}
