@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotfirmwaredefense.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The status of firmware scan.
 */
public enum class Status(
    public val javaValue: com.pulumi.azurenative.iotfirmwaredefense.enums.Status,
) : ConvertibleToJava<com.pulumi.azurenative.iotfirmwaredefense.enums.Status> {
    Pending(com.pulumi.azurenative.iotfirmwaredefense.enums.Status.Pending),
    Extracting(com.pulumi.azurenative.iotfirmwaredefense.enums.Status.Extracting),
    Analyzing(com.pulumi.azurenative.iotfirmwaredefense.enums.Status.Analyzing),
    Ready(com.pulumi.azurenative.iotfirmwaredefense.enums.Status.Ready),
    Error(com.pulumi.azurenative.iotfirmwaredefense.enums.Status.Error),
    ;

    override fun toJava(): com.pulumi.azurenative.iotfirmwaredefense.enums.Status = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.iotfirmwaredefense.enums.Status): Status =
            Status.values().first { it.javaValue == javaType }
    }
}
