@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotfirmwaredefense.kotlin.inputs

import com.pulumi.azurenative.iotfirmwaredefense.inputs.GetFirmwarePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property firmwareId The id of the firmware.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property workspaceName The name of the firmware analysis workspace.
 */
public data class GetFirmwarePlainArgs(
    public val firmwareId: String,
    public val resourceGroupName: String,
    public val workspaceName: String,
) : ConvertibleToJava<com.pulumi.azurenative.iotfirmwaredefense.inputs.GetFirmwarePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.iotfirmwaredefense.inputs.GetFirmwarePlainArgs =
        com.pulumi.azurenative.iotfirmwaredefense.inputs.GetFirmwarePlainArgs.builder()
            .firmwareId(firmwareId.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .workspaceName(workspaceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetFirmwarePlainArgs].
 */
@PulumiTagMarker
public class GetFirmwarePlainArgsBuilder internal constructor() {
    private var firmwareId: String? = null

    private var resourceGroupName: String? = null

    private var workspaceName: String? = null

    /**
     * @param value The id of the firmware.
     */
    @JvmName("hrxuaxfrdjpwamix")
    public suspend fun firmwareId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.firmwareId = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("ghpnwmjmrwbqftsx")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the firmware analysis workspace.
     */
    @JvmName("rjbqjjpfpfekguyy")
    public suspend fun workspaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.workspaceName = mapped
    }

    internal fun build(): GetFirmwarePlainArgs = GetFirmwarePlainArgs(
        firmwareId = firmwareId ?: throw PulumiNullFieldException("firmwareId"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        workspaceName = workspaceName ?: throw PulumiNullFieldException("workspaceName"),
    )
}
