@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsdataprocessor.kotlin.inputs

import com.pulumi.azurenative.iotoperationsdataprocessor.inputs.DatasetPropertyKeyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Key that can be used for joining on enrich.
 * @property path Path to the input value from the message.
 * @property primaryKey If true the property will be used as a primary key. At most one primary key can exists.
 */
public data class DatasetPropertyKeyArgs(
    public val path: Output<String>,
    public val primaryKey: Output<Boolean>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.iotoperationsdataprocessor.inputs.DatasetPropertyKeyArgs> {
    override fun toJava():
        com.pulumi.azurenative.iotoperationsdataprocessor.inputs.DatasetPropertyKeyArgs =
        com.pulumi.azurenative.iotoperationsdataprocessor.inputs.DatasetPropertyKeyArgs.builder()
            .path(path.applyValue({ args0 -> args0 }))
            .primaryKey(primaryKey?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DatasetPropertyKeyArgs].
 */
@PulumiTagMarker
public class DatasetPropertyKeyArgsBuilder internal constructor() {
    private var path: Output<String>? = null

    private var primaryKey: Output<Boolean>? = null

    /**
     * @param value Path to the input value from the message.
     */
    @JvmName("gyuubpjahvvsoiue")
    public suspend fun path(`value`: Output<String>) {
        this.path = value
    }

    /**
     * @param value If true the property will be used as a primary key. At most one primary key can exists.
     */
    @JvmName("wvbgslndiqlgvgrl")
    public suspend fun primaryKey(`value`: Output<Boolean>) {
        this.primaryKey = value
    }

    /**
     * @param value Path to the input value from the message.
     */
    @JvmName("nacagabgrpwbvjye")
    public suspend fun path(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.path = mapped
    }

    /**
     * @param value If true the property will be used as a primary key. At most one primary key can exists.
     */
    @JvmName("aavfyqbggmmuhtoq")
    public suspend fun primaryKey(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.primaryKey = mapped
    }

    internal fun build(): DatasetPropertyKeyArgs = DatasetPropertyKeyArgs(
        path = path ?: throw PulumiNullFieldException("path"),
        primaryKey = primaryKey,
    )
}
