@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsdataprocessor.kotlin.inputs

import com.pulumi.azurenative.iotoperationsdataprocessor.inputs.PipelineStageArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Stage configurations for all Pipeline processing and output stages.
 * @property description Description for stage.
 * @property next Next stage in the pipeline. Not required if output stage.
 * @property type ARM resource type.
 */
public data class PipelineStageArgs(
    public val description: Output<String>? = null,
    public val next: Output<List<String>>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.iotoperationsdataprocessor.inputs.PipelineStageArgs> {
    override fun toJava(): com.pulumi.azurenative.iotoperationsdataprocessor.inputs.PipelineStageArgs =
        com.pulumi.azurenative.iotoperationsdataprocessor.inputs.PipelineStageArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .next(next?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PipelineStageArgs].
 */
@PulumiTagMarker
public class PipelineStageArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var next: Output<List<String>>? = null

    private var type: Output<String>? = null

    /**
     * @param value Description for stage.
     */
    @JvmName("rptmwqmckcqtxdae")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Next stage in the pipeline. Not required if output stage.
     */
    @JvmName("obrmjfsqksndorjg")
    public suspend fun next(`value`: Output<List<String>>) {
        this.next = value
    }

    @JvmName("nguivtxykrxnnqnj")
    public suspend fun next(vararg values: Output<String>) {
        this.next = Output.all(values.asList())
    }

    /**
     * @param values Next stage in the pipeline. Not required if output stage.
     */
    @JvmName("khsvpefivyajupiu")
    public suspend fun next(values: List<Output<String>>) {
        this.next = Output.all(values)
    }

    /**
     * @param value ARM resource type.
     */
    @JvmName("fuyjcdlpwadlpkmf")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Description for stage.
     */
    @JvmName("tclbkabrgmsvhter")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Next stage in the pipeline. Not required if output stage.
     */
    @JvmName("ngqugkpowrhcafhq")
    public suspend fun next(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.next = mapped
    }

    /**
     * @param values Next stage in the pipeline. Not required if output stage.
     */
    @JvmName("sotxvunvjkbukmrr")
    public suspend fun next(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.next = mapped
    }

    /**
     * @param value ARM resource type.
     */
    @JvmName("fvomvdiqvcuiuxif")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): PipelineStageArgs = PipelineStageArgs(
        description = description,
        next = next,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
