@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin

import com.pulumi.azurenative.iotoperationsmq.BrokerAuthenticationArgs.builder
import com.pulumi.azurenative.iotoperationsmq.kotlin.inputs.BrokerAuthenticatorMethodsArgs
import com.pulumi.azurenative.iotoperationsmq.kotlin.inputs.BrokerAuthenticatorMethodsArgsBuilder
import com.pulumi.azurenative.iotoperationsmq.kotlin.inputs.ExtendedLocationPropertyArgs
import com.pulumi.azurenative.iotoperationsmq.kotlin.inputs.ExtendedLocationPropertyArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * MQ broker/authentication resource
 * Azure REST API version: 2023-10-04-preview.
 * ## Example Usage
 * ### BrokerAuthentication_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var brokerAuthentication = new AzureNative.IoTOperationsMQ.BrokerAuthentication("brokerAuthentication", new()
 *     {
 *         AuthenticationMethods = new[]
 *         {
 *             new AzureNative.IoTOperationsMQ.Inputs.BrokerAuthenticatorMethodsArgs
 *             {
 *                 Custom = new AzureNative.IoTOperationsMQ.Inputs.BrokerAuthenticatorMethodCustomArgs
 *                 {
 *                     Auth = new AzureNative.IoTOperationsMQ.Inputs.BrokerAuthenticatorCustomAuthArgs
 *                     {
 *                         X509 = new AzureNative.IoTOperationsMQ.Inputs.BrokerAuthenticatorCustomAuthX509Args
 *                         {
 *                             KeyVault = new AzureNative.IoTOperationsMQ.Inputs.KeyVaultCertificatePropertiesArgs
 *                             {
 *                                 Vault = new AzureNative.IoTOperationsMQ.Inputs.KeyVaultConnectionPropertiesArgs
 *                                 {
 *                                     Credentials = new AzureNative.IoTOperationsMQ.Inputs.KeyVaultCredentialsPropertiesArgs
 *                                     {
 *                                         ServicePrincipalLocalSecretName = "wuimjwpbhoglbsxxa",
 *                                     },
 *                                     DirectoryId = "eyjniptiykzcgbzok",
 *                                     Name = "lxmwfan",
 *                                 },
 *                                 VaultCaChainSecret = new AzureNative.IoTOperationsMQ.Inputs.KeyVaultSecretObjectArgs
 *                                 {
 *                                     Name = "bmectskddmpjxnsogwooexj",
 *                                     Version = "unjfbf",
 *                                 },
 *                                 VaultCert = new AzureNative.IoTOperationsMQ.Inputs.KeyVaultSecretObjectArgs
 *                                 {
 *                                     Name = "bmectskddmpjxnsogwooexj",
 *                                     Version = "unjfbf",
 *                                 },
 *                             },
 *                             SecretName = "dordbwjewnqkhfd",
 *                         },
 *                     },
 *                     CaCertConfigMap = "diufihyysdcosgy",
 *                     Endpoint = "yy",
 *                     Headers = null,
 *                 },
 *                 Sat = new AzureNative.IoTOperationsMQ.Inputs.BrokerAuthenticatorMethodSatArgs
 *                 {
 *                     Audiences = new[]
 *                     {
 *                         "fiyitxutbuuhwtltukyjacads",
 *                     },
 *                 },
 *                 Svid = new AzureNative.IoTOperationsMQ.Inputs.BrokerAuthenticatorMethodSvidArgs
 *                 {
 *                     AgentSocketPath = "gnyowebmeaj",
 *                     IdentityMaxRetry = 4031184731,
 *                     IdentityWaitRetryMs = 2243705844935085568,
 *                 },
 *                 UsernamePassword = new AzureNative.IoTOperationsMQ.Inputs.BrokerAuthenticatorMethodUsernamePasswordArgs
 *                 {
 *                     KeyVault = new AzureNative.IoTOperationsMQ.Inputs.KeyVaultSecretPropertiesArgs
 *                     {
 *                         Vault = new AzureNative.IoTOperationsMQ.Inputs.KeyVaultConnectionPropertiesArgs
 *                         {
 *                             Credentials = new AzureNative.IoTOperationsMQ.Inputs.KeyVaultCredentialsPropertiesArgs
 *                             {
 *                                 ServicePrincipalLocalSecretName = "wuimjwpbhoglbsxxa",
 *                             },
 *                             DirectoryId = "eyjniptiykzcgbzok",
 *                             Name = "lxmwfan",
 *                         },
 *                         VaultSecret = new AzureNative.IoTOperationsMQ.Inputs.KeyVaultSecretObjectArgs
 *                         {
 *                             Name = "bmectskddmpjxnsogwooexj",
 *                             Version = "unjfbf",
 *                         },
 *                     },
 *                     SecretName = "blk",
 *                 },
 *                 X509 = new AzureNative.IoTOperationsMQ.Inputs.BrokerAuthenticatorMethodX509Args
 *                 {
 *                     Attributes = new AzureNative.IoTOperationsMQ.Inputs.BrokerAuthenticatorMethodX509AttributesArgs
 *                     {
 *                         KeyVault = new AzureNative.IoTOperationsMQ.Inputs.KeyVaultSecretPropertiesArgs
 *                         {
 *                             Vault = new AzureNative.IoTOperationsMQ.Inputs.KeyVaultConnectionPropertiesArgs
 *                             {
 *                                 Credentials = new AzureNative.IoTOperationsMQ.Inputs.KeyVaultCredentialsPropertiesArgs
 *                                 {
 *                                     ServicePrincipalLocalSecretName = "wuimjwpbhoglbsxxa",
 *                                 },
 *                                 DirectoryId = "eyjniptiykzcgbzok",
 *                                 Name = "lxmwfan",
 *                             },
 *                             VaultSecret = new AzureNative.IoTOperationsMQ.Inputs.KeyVaultSecretObjectArgs
 *                             {
 *                                 Name = "bmectskddmpjxnsogwooexj",
 *                                 Version = "unjfbf",
 *                             },
 *                         },
 *                         SecretName = "ybcke",
 *                     },
 *                     TrustedClientCaCertConfigMap = "udidafmnpt",
 *                 },
 *             },
 *         },
 *         AuthenticationName = "lUo-GQ3-95F-1O-",
 *         BrokerName = "87v1GC9557XuP-JLI4-",
 *         ExtendedLocation = new AzureNative.IoTOperationsMQ.Inputs.ExtendedLocationPropertyArgs
 *         {
 *             Name = "an",
 *             Type = "CustomLocation",
 *         },
 *         ListenerRef = new[]
 *         {
 *             "dhjpypfjzzmwm",
 *         },
 *         Location = "vtxegvaeqwyupplnm",
 *         MqName = "2S-A2-D9kC946K",
 *         ResourceGroupName = "rgiotoperationsmq",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/iotoperationsmq/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := iotoperationsmq.NewBrokerAuthentication(ctx, "brokerAuthentication", &iotoperationsmq.BrokerAuthenticationArgs{
 * 			AuthenticationMethods: []iotoperationsmq.BrokerAuthenticatorMethodsArgs{
 * 				{
 * 					Custom: {
 * 						Auth: {
 * 							X509: {
 * 								KeyVault: {
 * 									Vault: {
 * 										Credentials: {
 * 											ServicePrincipalLocalSecretName: pulumi.String("wuimjwpbhoglbsxxa"),
 * 										},
 * 										DirectoryId: pulumi.String("eyjniptiykzcgbzok"),
 * 										Name:        pulumi.String("lxmwfan"),
 * 									},
 * 									VaultCaChainSecret: {
 * 										Name:    pulumi.String("bmectskddmpjxnsogwooexj"),
 * 										Version: pulumi.String("unjfbf"),
 * 									},
 * 									VaultCert: {
 * 										Name:    pulumi.String("bmectskddmpjxnsogwooexj"),
 * 										Version: pulumi.String("unjfbf"),
 * 									},
 * 								},
 * 								SecretName: pulumi.String("dordbwjewnqkhfd"),
 * 							},
 * 						},
 * 						CaCertConfigMap: pulumi.String("diufihyysdcosgy"),
 * 						Endpoint:        pulumi.String("yy"),
 * 						Headers:         nil,
 * 					},
 * 					Sat: {
 * 						Audiences: pulumi.StringArray{
 * 							pulumi.String("fiyitxutbuuhwtltukyjacads"),
 * 						},
 * 					},
 * 					Svid: {
 * 						AgentSocketPath:     pulumi.String("gnyowebmeaj"),
 * 						IdentityMaxRetry:    pulumi.Float64(4031184731),
 * 						IdentityWaitRetryMs: pulumi.Float64(2243705844935085568),
 * 					},
 * 					UsernamePassword: {
 * 						KeyVault: {
 * 							Vault: {
 * 								Credentials: {
 * 									ServicePrincipalLocalSecretName: pulumi.String("wuimjwpbhoglbsxxa"),
 * 								},
 * 								DirectoryId: pulumi.String("eyjniptiykzcgbzok"),
 * 								Name:        pulumi.String("lxmwfan"),
 * 							},
 * 							VaultSecret: {
 * 								Name:    pulumi.String("bmectskddmpjxnsogwooexj"),
 * 								Version: pulumi.String("unjfbf"),
 * 							},
 * 						},
 * 						SecretName: pulumi.String("blk"),
 * 					},
 * 					X509: {
 * 						Attributes: {
 * 							KeyVault: {
 * 								Vault: {
 * 									Credentials: {
 * 										ServicePrincipalLocalSecretName: pulumi.String("wuimjwpbhoglbsxxa"),
 * 									},
 * 									DirectoryId: pulumi.String("eyjniptiykzcgbzok"),
 * 									Name:        pulumi.String("lxmwfan"),
 * 								},
 * 								VaultSecret: {
 * 									Name:    pulumi.String("bmectskddmpjxnsogwooexj"),
 * 									Version: pulumi.String("unjfbf"),
 * 								},
 * 							},
 * 							SecretName: pulumi.String("ybcke"),
 * 						},
 * 						TrustedClientCaCertConfigMap: pulumi.String("udidafmnpt"),
 * 					},
 * 				},
 * 			},
 * 			AuthenticationName: pulumi.String("lUo-GQ3-95F-1O-"),
 * 			BrokerName:         pulumi.String("87v1GC9557XuP-JLI4-"),
 * 			ExtendedLocation: &iotoperationsmq.ExtendedLocationPropertyArgs{
 * 				Name: pulumi.String("an"),
 * 				Type: pulumi.String("CustomLocation"),
 * 			},
 * 			ListenerRef: pulumi.StringArray{
 * 				pulumi.String("dhjpypfjzzmwm"),
 * 			},
 * 			Location:          pulumi.String("vtxegvaeqwyupplnm"),
 * 			MqName:            pulumi.String("2S-A2-D9kC946K"),
 * 			ResourceGroupName: pulumi.String("rgiotoperationsmq"),
 * 			Tags:              nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.iotoperationsmq.BrokerAuthentication;
 * import com.pulumi.azurenative.iotoperationsmq.BrokerAuthenticationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var brokerAuthentication = new BrokerAuthentication("brokerAuthentication", BrokerAuthenticationArgs.builder()
 *             .authenticationMethods(Map.ofEntries(
 *                 Map.entry("custom", Map.ofEntries(
 *                     Map.entry("auth", Map.of("x509", Map.ofEntries(
 *                         Map.entry("keyVault", Map.ofEntries(
 *                             Map.entry("vault", Map.ofEntries(
 *                                 Map.entry("credentials", Map.of("servicePrincipalLocalSecretName", "wuimjwpbhoglbsxxa")),
 *                                 Map.entry("directoryId", "eyjniptiykzcgbzok"),
 *                                 Map.entry("name", "lxmwfan")
 *                             )),
 *                             Map.entry("vaultCaChainSecret", Map.ofEntries(
 *                                 Map.entry("name", "bmectskddmpjxnsogwooexj"),
 *                                 Map.entry("version", "unjfbf")
 *                             )),
 *                             Map.entry("vaultCert", Map.ofEntries(
 *                                 Map.entry("name", "bmectskddmpjxnsogwooexj"),
 *                                 Map.entry("version", "unjfbf")
 *                             ))
 *                         )),
 *                         Map.entry("secretName", "dordbwjewnqkhfd")
 *                     ))),
 *                     Map.entry("caCertConfigMap", "diufihyysdcosgy"),
 *                     Map.entry("endpoint", "yy"),
 *                     Map.entry("headers", )
 *                 )),
 *                 Map.entry("sat", Map.of("audiences", "fiyitxutbuuhwtltukyjacads")),
 *                 Map.entry("svid", Map.ofEntries(
 *                     Map.entry("agentSocketPath", "gnyowebmeaj"),
 *                     Map.entry("identityMaxRetry", 4031184731),
 *                     Map.entry("identityWaitRetryMs", 2243705844935085568)
 *                 )),
 *                 Map.entry("usernamePassword", Map.ofEntries(
 *                     Map.entry("keyVault", Map.ofEntries(
 *                         Map.entry("vault", Map.ofEntries(
 *                             Map.entry("credentials", Map.of("servicePrincipalLocalSecretName", "wuimjwpbhoglbsxxa")),
 *                             Map.entry("directoryId", "eyjniptiykzcgbzok"),
 *                             Map.entry("name", "lxmwfan")
 *                         )),
 *                         Map.entry("vaultSecret", Map.ofEntries(
 *                             Map.entry("name", "bmectskddmpjxnsogwooexj"),
 *                             Map.entry("version", "unjfbf")
 *                         ))
 *                     )),
 *                     Map.entry("secretName", "blk")
 *                 )),
 *                 Map.entry("x509", Map.ofEntries(
 *                     Map.entry("attributes", Map.ofEntries(
 *                         Map.entry("keyVault", Map.ofEntries(
 *                             Map.entry("vault", Map.ofEntries(
 *                                 Map.entry("credentials", Map.of("servicePrincipalLocalSecretName", "wuimjwpbhoglbsxxa")),
 *                                 Map.entry("directoryId", "eyjniptiykzcgbzok"),
 *                                 Map.entry("name", "lxmwfan")
 *                             )),
 *                             Map.entry("vaultSecret", Map.ofEntries(
 *                                 Map.entry("name", "bmectskddmpjxnsogwooexj"),
 *                                 Map.entry("version", "unjfbf")
 *                             ))
 *                         )),
 *                         Map.entry("secretName", "ybcke")
 *                     )),
 *                     Map.entry("trustedClientCaCertConfigMap", "udidafmnpt")
 *                 ))
 *             ))
 *             .authenticationName("lUo-GQ3-95F-1O-")
 *             .brokerName("87v1GC9557XuP-JLI4-")
 *             .extendedLocation(Map.ofEntries(
 *                 Map.entry("name", "an"),
 *                 Map.entry("type", "CustomLocation")
 *             ))
 *             .listenerRef("dhjpypfjzzmwm")
 *             .location("vtxegvaeqwyupplnm")
 *             .mqName("2S-A2-D9kC946K")
 *             .resourceGroupName("rgiotoperationsmq")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:iotoperationsmq:BrokerAuthentication ktgtbdoqrmk /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IoTOperationsMQ/mq/{mqName}/broker/{brokerName}/authentication/{authenticationName}
 * ```
 * @property authenticationMethods The list of authentication methods supported by the Authentication Resource. For each array element, NOTE - Enum only authenticator type supported.
 * @property authenticationName Name of MQ broker/authentication resource
 * @property brokerName Name of MQ broker resource
 * @property extendedLocation Extended Location
 * @property listenerRef The array of listener Resources it supports.
 * @property location The geo-location where the resource lives
 * @property mqName Name of MQ resource
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 */
public data class BrokerAuthenticationArgs(
    public val authenticationMethods: Output<List<BrokerAuthenticatorMethodsArgs>>? = null,
    public val authenticationName: Output<String>? = null,
    public val brokerName: Output<String>? = null,
    public val extendedLocation: Output<ExtendedLocationPropertyArgs>? = null,
    public val listenerRef: Output<List<String>>? = null,
    public val location: Output<String>? = null,
    public val mqName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.iotoperationsmq.BrokerAuthenticationArgs> {
    override fun toJava(): com.pulumi.azurenative.iotoperationsmq.BrokerAuthenticationArgs =
        com.pulumi.azurenative.iotoperationsmq.BrokerAuthenticationArgs.builder()
            .authenticationMethods(
                authenticationMethods?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .authenticationName(authenticationName?.applyValue({ args0 -> args0 }))
            .brokerName(brokerName?.applyValue({ args0 -> args0 }))
            .extendedLocation(extendedLocation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .listenerRef(listenerRef?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .mqName(mqName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [BrokerAuthenticationArgs].
 */
@PulumiTagMarker
public class BrokerAuthenticationArgsBuilder internal constructor() {
    private var authenticationMethods: Output<List<BrokerAuthenticatorMethodsArgs>>? = null

    private var authenticationName: Output<String>? = null

    private var brokerName: Output<String>? = null

    private var extendedLocation: Output<ExtendedLocationPropertyArgs>? = null

    private var listenerRef: Output<List<String>>? = null

    private var location: Output<String>? = null

    private var mqName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The list of authentication methods supported by the Authentication Resource. For each array element, NOTE - Enum only authenticator type supported.
     */
    @JvmName("vgwlqtaavynlxlvp")
    public suspend fun authenticationMethods(`value`: Output<List<BrokerAuthenticatorMethodsArgs>>) {
        this.authenticationMethods = value
    }

    @JvmName("ytrmqrdbuujvirsu")
    public suspend fun authenticationMethods(vararg values: Output<BrokerAuthenticatorMethodsArgs>) {
        this.authenticationMethods = Output.all(values.asList())
    }

    /**
     * @param values The list of authentication methods supported by the Authentication Resource. For each array element, NOTE - Enum only authenticator type supported.
     */
    @JvmName("cvcvmjmmdwygnxcq")
    public suspend fun authenticationMethods(values: List<Output<BrokerAuthenticatorMethodsArgs>>) {
        this.authenticationMethods = Output.all(values)
    }

    /**
     * @param value Name of MQ broker/authentication resource
     */
    @JvmName("bfgownjpwpkjvnhs")
    public suspend fun authenticationName(`value`: Output<String>) {
        this.authenticationName = value
    }

    /**
     * @param value Name of MQ broker resource
     */
    @JvmName("vthbfpyxmmlshamw")
    public suspend fun brokerName(`value`: Output<String>) {
        this.brokerName = value
    }

    /**
     * @param value Extended Location
     */
    @JvmName("wtbpnjnghydtsaab")
    public suspend fun extendedLocation(`value`: Output<ExtendedLocationPropertyArgs>) {
        this.extendedLocation = value
    }

    /**
     * @param value The array of listener Resources it supports.
     */
    @JvmName("qwuwdwojyltougmj")
    public suspend fun listenerRef(`value`: Output<List<String>>) {
        this.listenerRef = value
    }

    @JvmName("skpbhmdmsjhenkrg")
    public suspend fun listenerRef(vararg values: Output<String>) {
        this.listenerRef = Output.all(values.asList())
    }

    /**
     * @param values The array of listener Resources it supports.
     */
    @JvmName("upsuojxxojodajme")
    public suspend fun listenerRef(values: List<Output<String>>) {
        this.listenerRef = Output.all(values)
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("gsdccnahjnmncsob")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Name of MQ resource
     */
    @JvmName("yoivasjrywafjhbu")
    public suspend fun mqName(`value`: Output<String>) {
        this.mqName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("vglgfdhtbghhsjnw")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("vfxsjunoskbdfycb")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The list of authentication methods supported by the Authentication Resource. For each array element, NOTE - Enum only authenticator type supported.
     */
    @JvmName("ywffsgogdnmayswq")
    public suspend fun authenticationMethods(`value`: List<BrokerAuthenticatorMethodsArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authenticationMethods = mapped
    }

    /**
     * @param argument The list of authentication methods supported by the Authentication Resource. For each array element, NOTE - Enum only authenticator type supported.
     */
    @JvmName("ukwpaxtxcwmcvqya")
    public suspend
    fun authenticationMethods(argument: List<suspend BrokerAuthenticatorMethodsArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            BrokerAuthenticatorMethodsArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.authenticationMethods = mapped
    }

    /**
     * @param argument The list of authentication methods supported by the Authentication Resource. For each array element, NOTE - Enum only authenticator type supported.
     */
    @JvmName("rgtnwrqjunskgfay")
    public suspend fun authenticationMethods(
        vararg
        argument: suspend BrokerAuthenticatorMethodsArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            BrokerAuthenticatorMethodsArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.authenticationMethods = mapped
    }

    /**
     * @param argument The list of authentication methods supported by the Authentication Resource. For each array element, NOTE - Enum only authenticator type supported.
     */
    @JvmName("jytqlifjsbpdkgxm")
    public suspend
    fun authenticationMethods(argument: suspend BrokerAuthenticatorMethodsArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            BrokerAuthenticatorMethodsArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.authenticationMethods = mapped
    }

    /**
     * @param values The list of authentication methods supported by the Authentication Resource. For each array element, NOTE - Enum only authenticator type supported.
     */
    @JvmName("towdxiuxuvpwjqom")
    public suspend fun authenticationMethods(vararg values: BrokerAuthenticatorMethodsArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authenticationMethods = mapped
    }

    /**
     * @param value Name of MQ broker/authentication resource
     */
    @JvmName("vgoxwefvoeccnfeq")
    public suspend fun authenticationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authenticationName = mapped
    }

    /**
     * @param value Name of MQ broker resource
     */
    @JvmName("lfgknevoxtwnqbya")
    public suspend fun brokerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.brokerName = mapped
    }

    /**
     * @param value Extended Location
     */
    @JvmName("otgtficngntwntqh")
    public suspend fun extendedLocation(`value`: ExtendedLocationPropertyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extendedLocation = mapped
    }

    /**
     * @param argument Extended Location
     */
    @JvmName("waiixpmlratxwmep")
    public suspend
    fun extendedLocation(argument: suspend ExtendedLocationPropertyArgsBuilder.() -> Unit) {
        val toBeMapped = ExtendedLocationPropertyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.extendedLocation = mapped
    }

    /**
     * @param value The array of listener Resources it supports.
     */
    @JvmName("vtlpphxyrcbuycvc")
    public suspend fun listenerRef(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.listenerRef = mapped
    }

    /**
     * @param values The array of listener Resources it supports.
     */
    @JvmName("jvyhtcewvbmcjhph")
    public suspend fun listenerRef(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.listenerRef = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("beptwklxeapyregp")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Name of MQ resource
     */
    @JvmName("cawrejtemsbkjmln")
    public suspend fun mqName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mqName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("uircschvunyxgbxq")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("nbvswytelhckbbmx")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("dgrmmpxnukkqffph")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): BrokerAuthenticationArgs = BrokerAuthenticationArgs(
        authenticationMethods = authenticationMethods,
        authenticationName = authenticationName,
        brokerName = brokerName,
        extendedLocation = extendedLocation,
        listenerRef = listenerRef,
        location = location,
        mqName = mqName,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
