@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin

import com.pulumi.azurenative.iotoperationsmq.BrokerAuthorizationArgs.builder
import com.pulumi.azurenative.iotoperationsmq.kotlin.inputs.AuthorizationConfigArgs
import com.pulumi.azurenative.iotoperationsmq.kotlin.inputs.AuthorizationConfigArgsBuilder
import com.pulumi.azurenative.iotoperationsmq.kotlin.inputs.ExtendedLocationPropertyArgs
import com.pulumi.azurenative.iotoperationsmq.kotlin.inputs.ExtendedLocationPropertyArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * MQ broker/authorization resource
 * Azure REST API version: 2023-10-04-preview.
 * ## Example Usage
 * ### BrokerAuthorization_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var brokerAuthorization = new AzureNative.IoTOperationsMQ.BrokerAuthorization("brokerAuthorization", new()
 *     {
 *         AuthorizationName = "C15G",
 *         AuthorizationPolicies = new AzureNative.IoTOperationsMQ.Inputs.AuthorizationConfigArgs
 *         {
 *             EnableCache = true,
 *             Rules = new[]
 *             {
 *                 new AzureNative.IoTOperationsMQ.Inputs.AuthorizationBasicRuleArgs
 *                 {
 *                     BrokerResources = new[]
 *                     {
 *                         new AzureNative.IoTOperationsMQ.Inputs.ResourceInfoDefinitionArgs
 *                         {
 *                             Method = "Connect",
 *                             Topics = new[]
 *                             {
 *                                 "v",
 *                             },
 *                         },
 *                     },
 *                     Principals = new AzureNative.IoTOperationsMQ.Inputs.PrincipalDefinitionArgs
 *                     {
 *                         Attributes = new[]
 *                         {
 *                             null,
 *                         },
 *                         Clientids = new[]
 *                         {
 *                             "smrfzvniq",
 *                         },
 *                         Usernames = new[]
 *                         {
 *                             "jtwwmsrzriat",
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *         BrokerName = "7E0-tXS-6u1h-Vx396----",
 *         ExtendedLocation = new AzureNative.IoTOperationsMQ.Inputs.ExtendedLocationPropertyArgs
 *         {
 *             Name = "an",
 *             Type = "CustomLocation",
 *         },
 *         ListenerRef = new[]
 *         {
 *             "mxgpbyb",
 *         },
 *         Location = "bvgohixie",
 *         MqName = "Zz22-b2VC-9",
 *         ResourceGroupName = "rgiotoperationsmq",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/iotoperationsmq/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := iotoperationsmq.NewBrokerAuthorization(ctx, "brokerAuthorization", &iotoperationsmq.BrokerAuthorizationArgs{
 * AuthorizationName: pulumi.String("C15G"),
 * AuthorizationPolicies: iotoperationsmq.AuthorizationConfigResponse{
 * EnableCache: pulumi.Bool(true),
 * Rules: iotoperationsmq.AuthorizationBasicRuleArray{
 * interface{}{
 * BrokerResources: iotoperationsmq.ResourceInfoDefinitionArray{
 * &iotoperationsmq.ResourceInfoDefinitionArgs{
 * Method: pulumi.String("Connect"),
 * Topics: pulumi.StringArray{
 * pulumi.String("v"),
 * },
 * },
 * },
 * Principals: &iotoperationsmq.PrincipalDefinitionArgs{
 * Attributes: pulumi.StringMapArray{
 * nil,
 * },
 * Clientids: pulumi.StringArray{
 * pulumi.String("smrfzvniq"),
 * },
 * Usernames: pulumi.StringArray{
 * pulumi.String("jtwwmsrzriat"),
 * },
 * },
 * },
 * },
 * },
 * BrokerName: pulumi.String("7E0-tXS-6u1h-Vx396----"),
 * ExtendedLocation: &iotoperationsmq.ExtendedLocationPropertyArgs{
 * Name: pulumi.String("an"),
 * Type: pulumi.String("CustomLocation"),
 * },
 * ListenerRef: pulumi.StringArray{
 * pulumi.String("mxgpbyb"),
 * },
 * Location: pulumi.String("bvgohixie"),
 * MqName: pulumi.String("Zz22-b2VC-9"),
 * ResourceGroupName: pulumi.String("rgiotoperationsmq"),
 * Tags: nil,
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.iotoperationsmq.BrokerAuthorization;
 * import com.pulumi.azurenative.iotoperationsmq.BrokerAuthorizationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var brokerAuthorization = new BrokerAuthorization("brokerAuthorization", BrokerAuthorizationArgs.builder()
 *             .authorizationName("C15G")
 *             .authorizationPolicies(Map.ofEntries(
 *                 Map.entry("enableCache", true),
 *                 Map.entry("rules", Map.ofEntries(
 *                     Map.entry("brokerResources", Map.ofEntries(
 *                         Map.entry("method", "Connect"),
 *                         Map.entry("topics", "v")
 *                     )),
 *                     Map.entry("principals", Map.ofEntries(
 *                         Map.entry("attributes", ),
 *                         Map.entry("clientids", "smrfzvniq"),
 *                         Map.entry("usernames", "jtwwmsrzriat")
 *                     ))
 *                 ))
 *             ))
 *             .brokerName("7E0-tXS-6u1h-Vx396----")
 *             .extendedLocation(Map.ofEntries(
 *                 Map.entry("name", "an"),
 *                 Map.entry("type", "CustomLocation")
 *             ))
 *             .listenerRef("mxgpbyb")
 *             .location("bvgohixie")
 *             .mqName("Zz22-b2VC-9")
 *             .resourceGroupName("rgiotoperationsmq")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:iotoperationsmq:BrokerAuthorization nwffklaehhtmhqcpjauqprvykdjzzd /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IoTOperationsMQ/mq/{mqName}/broker/{brokerName}/authorization/{authorizationName}
 * ```
 * @property authorizationName Name of MQ broker/authorization resource
 * @property authorizationPolicies The list of authorization policies supported by the Authorization Resource.
 * @property brokerName Name of MQ broker resource
 * @property extendedLocation Extended Location
 * @property listenerRef The array of listener Resources it supports.
 * @property location The geo-location where the resource lives
 * @property mqName Name of MQ resource
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 */
public data class BrokerAuthorizationArgs(
    public val authorizationName: Output<String>? = null,
    public val authorizationPolicies: Output<AuthorizationConfigArgs>? = null,
    public val brokerName: Output<String>? = null,
    public val extendedLocation: Output<ExtendedLocationPropertyArgs>? = null,
    public val listenerRef: Output<List<String>>? = null,
    public val location: Output<String>? = null,
    public val mqName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.iotoperationsmq.BrokerAuthorizationArgs> {
    override fun toJava(): com.pulumi.azurenative.iotoperationsmq.BrokerAuthorizationArgs =
        com.pulumi.azurenative.iotoperationsmq.BrokerAuthorizationArgs.builder()
            .authorizationName(authorizationName?.applyValue({ args0 -> args0 }))
            .authorizationPolicies(
                authorizationPolicies?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .brokerName(brokerName?.applyValue({ args0 -> args0 }))
            .extendedLocation(extendedLocation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .listenerRef(listenerRef?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .mqName(mqName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [BrokerAuthorizationArgs].
 */
@PulumiTagMarker
public class BrokerAuthorizationArgsBuilder internal constructor() {
    private var authorizationName: Output<String>? = null

    private var authorizationPolicies: Output<AuthorizationConfigArgs>? = null

    private var brokerName: Output<String>? = null

    private var extendedLocation: Output<ExtendedLocationPropertyArgs>? = null

    private var listenerRef: Output<List<String>>? = null

    private var location: Output<String>? = null

    private var mqName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Name of MQ broker/authorization resource
     */
    @JvmName("adcobwbycaaxdhsh")
    public suspend fun authorizationName(`value`: Output<String>) {
        this.authorizationName = value
    }

    /**
     * @param value The list of authorization policies supported by the Authorization Resource.
     */
    @JvmName("ofuiyjtolrryxejm")
    public suspend fun authorizationPolicies(`value`: Output<AuthorizationConfigArgs>) {
        this.authorizationPolicies = value
    }

    /**
     * @param value Name of MQ broker resource
     */
    @JvmName("kcpwbkwddefstxnm")
    public suspend fun brokerName(`value`: Output<String>) {
        this.brokerName = value
    }

    /**
     * @param value Extended Location
     */
    @JvmName("qitmrbouryamcpcl")
    public suspend fun extendedLocation(`value`: Output<ExtendedLocationPropertyArgs>) {
        this.extendedLocation = value
    }

    /**
     * @param value The array of listener Resources it supports.
     */
    @JvmName("epxvyscirridjebs")
    public suspend fun listenerRef(`value`: Output<List<String>>) {
        this.listenerRef = value
    }

    @JvmName("jtjgkcoliegivvwm")
    public suspend fun listenerRef(vararg values: Output<String>) {
        this.listenerRef = Output.all(values.asList())
    }

    /**
     * @param values The array of listener Resources it supports.
     */
    @JvmName("taiqjpmyaxjbtwlk")
    public suspend fun listenerRef(values: List<Output<String>>) {
        this.listenerRef = Output.all(values)
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("kwdnfjamjvkfwwta")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Name of MQ resource
     */
    @JvmName("ycnugocddeypapvg")
    public suspend fun mqName(`value`: Output<String>) {
        this.mqName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("xilainhhpbiaenxs")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("etsubgyatwyukvtx")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Name of MQ broker/authorization resource
     */
    @JvmName("pdexsoektlhbibmn")
    public suspend fun authorizationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authorizationName = mapped
    }

    /**
     * @param value The list of authorization policies supported by the Authorization Resource.
     */
    @JvmName("kycdtewgviyhkhcm")
    public suspend fun authorizationPolicies(`value`: AuthorizationConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authorizationPolicies = mapped
    }

    /**
     * @param argument The list of authorization policies supported by the Authorization Resource.
     */
    @JvmName("mxsuraoyniderylu")
    public suspend
    fun authorizationPolicies(argument: suspend AuthorizationConfigArgsBuilder.() -> Unit) {
        val toBeMapped = AuthorizationConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.authorizationPolicies = mapped
    }

    /**
     * @param value Name of MQ broker resource
     */
    @JvmName("rrwbcrmlobfaijxd")
    public suspend fun brokerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.brokerName = mapped
    }

    /**
     * @param value Extended Location
     */
    @JvmName("ctrmqobcfvtexvvj")
    public suspend fun extendedLocation(`value`: ExtendedLocationPropertyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extendedLocation = mapped
    }

    /**
     * @param argument Extended Location
     */
    @JvmName("afeyfukmsqohcxuw")
    public suspend
    fun extendedLocation(argument: suspend ExtendedLocationPropertyArgsBuilder.() -> Unit) {
        val toBeMapped = ExtendedLocationPropertyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.extendedLocation = mapped
    }

    /**
     * @param value The array of listener Resources it supports.
     */
    @JvmName("gigbnangcmkwkexn")
    public suspend fun listenerRef(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.listenerRef = mapped
    }

    /**
     * @param values The array of listener Resources it supports.
     */
    @JvmName("koiekxpqtkokcakp")
    public suspend fun listenerRef(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.listenerRef = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("hkcpnmcdbpmidyix")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Name of MQ resource
     */
    @JvmName("kdsygqsuteqdlxkf")
    public suspend fun mqName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mqName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("bkvehkninuphdpwd")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("rstctkonaunktapn")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("hyqoxiwtkvcwsutg")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): BrokerAuthorizationArgs = BrokerAuthorizationArgs(
        authorizationName = authorizationName,
        authorizationPolicies = authorizationPolicies,
        brokerName = brokerName,
        extendedLocation = extendedLocation,
        listenerRef = listenerRef,
        location = location,
        mqName = mqName,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
