@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin

import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.ContainerImageResponse
import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.ExtendedLocationPropertyResponse
import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.ContainerImageResponse.Companion.toKotlin as containerImageResponseToKotlin
import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.ExtendedLocationPropertyResponse.Companion.toKotlin as extendedLocationPropertyResponseToKotlin
import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [DiagnosticService].
 */
@PulumiTagMarker
public class DiagnosticServiceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DiagnosticServiceArgs = DiagnosticServiceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DiagnosticServiceArgsBuilder.() -> Unit) {
        val builder = DiagnosticServiceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): DiagnosticService {
        val builtJavaResource =
            com.pulumi.azurenative.iotoperationsmq.DiagnosticService(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return DiagnosticService(builtJavaResource)
    }
}

/**
 * MQ diagnostic services resource
 * Azure REST API version: 2023-10-04-preview.
 * ## Example Usage
 * ### DiagnosticService_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var diagnosticService = new AzureNative.IoTOperationsMQ.DiagnosticService("diagnosticService", new()
 *     {
 *         DataExportFrequencySeconds = 26084,
 *         DiagnosticServiceName = "73-1El3-1",
 *         ExtendedLocation = new AzureNative.IoTOperationsMQ.Inputs.ExtendedLocationPropertyArgs
 *         {
 *             Name = "an",
 *             Type = "CustomLocation",
 *         },
 *         Image = new AzureNative.IoTOperationsMQ.Inputs.ContainerImageArgs
 *         {
 *             PullPolicy = "imfuzvqxgbdwliqnn",
 *             PullSecrets = "klnqimxqsrdwhcqldjvdtsrs",
 *             Repository = "m",
 *             Tag = "jygfdiamhhm",
 *         },
 *         Location = "sbhavoiabxjpuq",
 *         LogFormat = "i",
 *         LogLevel = "aomqhmpa",
 *         MaxDataStorageSize = 3757017229,
 *         MetricsPort = 37109,
 *         MqName = "6RCAgs-XQ-Y2HsUF2",
 *         OpenTelemetryTracesCollectorAddr = "ggqmprmjlmmkfdpb",
 *         ResourceGroupName = "rgiotoperationsmq",
 *         StaleDataTimeoutSeconds = 51616,
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/iotoperationsmq/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := iotoperationsmq.NewDiagnosticService(ctx, "diagnosticService", &iotoperationsmq.DiagnosticServiceArgs{
 * 			DataExportFrequencySeconds: pulumi.Int(26084),
 * 			DiagnosticServiceName:      pulumi.String("73-1El3-1"),
 * 			ExtendedLocation: &iotoperationsmq.ExtendedLocationPropertyArgs{
 * 				Name: pulumi.String("an"),
 * 				Type: pulumi.String("CustomLocation"),
 * 			},
 * 			Image: &iotoperationsmq.ContainerImageArgs{
 * 				PullPolicy:  pulumi.String("imfuzvqxgbdwliqnn"),
 * 				PullSecrets: pulumi.String("klnqimxqsrdwhcqldjvdtsrs"),
 * 				Repository:  pulumi.String("m"),
 * 				Tag:         pulumi.String("jygfdiamhhm"),
 * 			},
 * 			Location:                         pulumi.String("sbhavoiabxjpuq"),
 * 			LogFormat:                        pulumi.String("i"),
 * 			LogLevel:                         pulumi.String("aomqhmpa"),
 * 			MaxDataStorageSize:               pulumi.Float64(3757017229),
 * 			MetricsPort:                      pulumi.Int(37109),
 * 			MqName:                           pulumi.String("6RCAgs-XQ-Y2HsUF2"),
 * 			OpenTelemetryTracesCollectorAddr: pulumi.String("ggqmprmjlmmkfdpb"),
 * 			ResourceGroupName:                pulumi.String("rgiotoperationsmq"),
 * 			StaleDataTimeoutSeconds:          pulumi.Int(51616),
 * 			Tags:                             nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.iotoperationsmq.DiagnosticService;
 * import com.pulumi.azurenative.iotoperationsmq.DiagnosticServiceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var diagnosticService = new DiagnosticService("diagnosticService", DiagnosticServiceArgs.builder()
 *             .dataExportFrequencySeconds(26084)
 *             .diagnosticServiceName("73-1El3-1")
 *             .extendedLocation(Map.ofEntries(
 *                 Map.entry("name", "an"),
 *                 Map.entry("type", "CustomLocation")
 *             ))
 *             .image(Map.ofEntries(
 *                 Map.entry("pullPolicy", "imfuzvqxgbdwliqnn"),
 *                 Map.entry("pullSecrets", "klnqimxqsrdwhcqldjvdtsrs"),
 *                 Map.entry("repository", "m"),
 *                 Map.entry("tag", "jygfdiamhhm")
 *             ))
 *             .location("sbhavoiabxjpuq")
 *             .logFormat("i")
 *             .logLevel("aomqhmpa")
 *             .maxDataStorageSize(3757017229)
 *             .metricsPort(37109)
 *             .mqName("6RCAgs-XQ-Y2HsUF2")
 *             .openTelemetryTracesCollectorAddr("ggqmprmjlmmkfdpb")
 *             .resourceGroupName("rgiotoperationsmq")
 *             .staleDataTimeoutSeconds(51616)
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:iotoperationsmq:DiagnosticService kdpnnlr /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IoTOperationsMQ/mq/{mqName}/diagnosticService/{diagnosticServiceName}
 * ```
 */
public class DiagnosticService internal constructor(
    override val javaResource: com.pulumi.azurenative.iotoperationsmq.DiagnosticService,
) : KotlinCustomResource(javaResource, DiagnosticServiceMapper) {
    /**
     * The frequency at which the data will be exported.
     */
    public val dataExportFrequencySeconds: Output<Int>?
        get() = javaResource.dataExportFrequencySeconds().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Extended Location
     */
    public val extendedLocation: Output<ExtendedLocationPropertyResponse>
        get() = javaResource.extendedLocation().applyValue({ args0 ->
            args0.let({ args0 ->
                extendedLocationPropertyResponseToKotlin(args0)
            })
        })

    /**
     * The details of Diagnostic Service Docker Image.
     */
    public val image: Output<ContainerImageResponse>
        get() = javaResource.image().applyValue({ args0 ->
            args0.let({ args0 ->
                containerImageResponseToKotlin(args0)
            })
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The format for the logs generated.
     */
    public val logFormat: Output<String>?
        get() = javaResource.logFormat().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The format for the logs generated.
     */
    public val logLevel: Output<String>?
        get() = javaResource.logLevel().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The maximum data stored in MiB.
     */
    public val maxDataStorageSize: Output<Double>?
        get() = javaResource.maxDataStorageSize().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The port at which metrics is exposed.
     */
    public val metricsPort: Output<Int>?
        get() = javaResource.metricsPort().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The destination to collect traces. Diagnostic service will push traces to this endpoint
     */
    public val openTelemetryTracesCollectorAddr: Output<String>?
        get() = javaResource.openTelemetryTracesCollectorAddr().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The status of the last operation.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Metric inactivity timeout.
     */
    public val staleDataTimeoutSeconds: Output<Int>?
        get() = javaResource.staleDataTimeoutSeconds().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object DiagnosticServiceMapper : ResourceMapper<DiagnosticService> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.iotoperationsmq.DiagnosticService::class == javaResource::class

    override fun map(javaResource: Resource): DiagnosticService = DiagnosticService(
        javaResource as
            com.pulumi.azurenative.iotoperationsmq.DiagnosticService,
    )
}

/**
 * @see [DiagnosticService].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DiagnosticService].
 */
public suspend fun diagnosticService(
    name: String,
    block: suspend DiagnosticServiceResourceBuilder.() -> Unit,
): DiagnosticService {
    val builder = DiagnosticServiceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DiagnosticService].
 * @param name The _unique_ name of the resulting resource.
 */
public fun diagnosticService(name: String): DiagnosticService {
    val builder = DiagnosticServiceResourceBuilder()
    builder.name(name)
    return builder.build()
}
