@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin

import com.pulumi.azurenative.iotoperationsmq.MqArgs.builder
import com.pulumi.azurenative.iotoperationsmq.kotlin.inputs.ExtendedLocationPropertyArgs
import com.pulumi.azurenative.iotoperationsmq.kotlin.inputs.ExtendedLocationPropertyArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * MQ resource
 * Azure REST API version: 2023-10-04-preview.
 * ## Example Usage
 * ### Mq_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var mq = new AzureNative.IoTOperationsMQ.Mq("mq", new()
 *     {
 *         ExtendedLocation = new AzureNative.IoTOperationsMQ.Inputs.ExtendedLocationPropertyArgs
 *         {
 *             Name = "an",
 *             Type = "CustomLocation",
 *         },
 *         Location = "qayqiarqxjennoyvglovxrdiccscq",
 *         MqName = "-MK0Vqe3K7Ji",
 *         ResourceGroupName = "rgiotoperationsmq",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/iotoperationsmq/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := iotoperationsmq.NewMq(ctx, "mq", &iotoperationsmq.MqArgs{
 * 			ExtendedLocation: &iotoperationsmq.ExtendedLocationPropertyArgs{
 * 				Name: pulumi.String("an"),
 * 				Type: pulumi.String("CustomLocation"),
 * 			},
 * 			Location:          pulumi.String("qayqiarqxjennoyvglovxrdiccscq"),
 * 			MqName:            pulumi.String("-MK0Vqe3K7Ji"),
 * 			ResourceGroupName: pulumi.String("rgiotoperationsmq"),
 * 			Tags:              nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.iotoperationsmq.Mq;
 * import com.pulumi.azurenative.iotoperationsmq.MqArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var mq = new Mq("mq", MqArgs.builder()
 *             .extendedLocation(Map.ofEntries(
 *                 Map.entry("name", "an"),
 *                 Map.entry("type", "CustomLocation")
 *             ))
 *             .location("qayqiarqxjennoyvglovxrdiccscq")
 *             .mqName("-MK0Vqe3K7Ji")
 *             .resourceGroupName("rgiotoperationsmq")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:iotoperationsmq:Mq mogfqcmgwpsw /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IoTOperationsMQ/mq/{mqName}
 * ```
 * @property extendedLocation Extended Location
 * @property location The geo-location where the resource lives
 * @property mqName Name of MQ resource
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 */
public data class MqArgs(
    public val extendedLocation: Output<ExtendedLocationPropertyArgs>? = null,
    public val location: Output<String>? = null,
    public val mqName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.iotoperationsmq.MqArgs> {
    override fun toJava(): com.pulumi.azurenative.iotoperationsmq.MqArgs =
        com.pulumi.azurenative.iotoperationsmq.MqArgs.builder()
            .extendedLocation(extendedLocation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .mqName(mqName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [MqArgs].
 */
@PulumiTagMarker
public class MqArgsBuilder internal constructor() {
    private var extendedLocation: Output<ExtendedLocationPropertyArgs>? = null

    private var location: Output<String>? = null

    private var mqName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Extended Location
     */
    @JvmName("xnynqujvamgxuenq")
    public suspend fun extendedLocation(`value`: Output<ExtendedLocationPropertyArgs>) {
        this.extendedLocation = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("jthltiyrrvdrstdi")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Name of MQ resource
     */
    @JvmName("ipfrsxpocvrbmfmu")
    public suspend fun mqName(`value`: Output<String>) {
        this.mqName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("rhqktbmrdkxgikly")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("cbcfekkpnkqhuhsv")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Extended Location
     */
    @JvmName("scpgwxuvfjaexggy")
    public suspend fun extendedLocation(`value`: ExtendedLocationPropertyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extendedLocation = mapped
    }

    /**
     * @param argument Extended Location
     */
    @JvmName("wddphjlmrrrpdjxw")
    public suspend
    fun extendedLocation(argument: suspend ExtendedLocationPropertyArgsBuilder.() -> Unit) {
        val toBeMapped = ExtendedLocationPropertyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.extendedLocation = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("iaecmfxmmlxvxncb")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Name of MQ resource
     */
    @JvmName("bxfnapygagtpruxs")
    public suspend fun mqName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mqName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("gkkfrocwgvhjawlh")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("rvqkagcfywiaqklv")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("xburwqhbjycuvnni")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): MqArgs = MqArgs(
        extendedLocation = extendedLocation,
        location = location,
        mqName = mqName,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
