@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin

import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.ContainerImageResponse
import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.ExtendedLocationPropertyResponse
import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.LocalBrokerConnectionSpecResponse
import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.MqttBridgeRemoteBrokerConnectionSpecResponse
import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.NodeTolerationsResponse
import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.ContainerImageResponse.Companion.toKotlin as containerImageResponseToKotlin
import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.ExtendedLocationPropertyResponse.Companion.toKotlin as extendedLocationPropertyResponseToKotlin
import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.LocalBrokerConnectionSpecResponse.Companion.toKotlin as localBrokerConnectionSpecResponseToKotlin
import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.MqttBridgeRemoteBrokerConnectionSpecResponse.Companion.toKotlin as mqttBridgeRemoteBrokerConnectionSpecResponseToKotlin
import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.NodeTolerationsResponse.Companion.toKotlin as nodeTolerationsResponseToKotlin
import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [MqttBridgeConnector].
 */
@PulumiTagMarker
public class MqttBridgeConnectorResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: MqttBridgeConnectorArgs = MqttBridgeConnectorArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend MqttBridgeConnectorArgsBuilder.() -> Unit) {
        val builder = MqttBridgeConnectorArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): MqttBridgeConnector {
        val builtJavaResource =
            com.pulumi.azurenative.iotoperationsmq.MqttBridgeConnector(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return MqttBridgeConnector(builtJavaResource)
    }
}

/**
 * MQ mqttBridgeConnector resource
 * Azure REST API version: 2023-10-04-preview.
 * ## Example Usage
 * ### MqttBridgeConnector_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var mqttBridgeConnector = new AzureNative.IoTOperationsMQ.MqttBridgeConnector("mqttBridgeConnector", new()
 *     {
 *         BridgeInstances = 4528,
 *         ClientIdPrefix = "yqipejvabahsexbnttiegjnh",
 *         ExtendedLocation = new AzureNative.IoTOperationsMQ.Inputs.ExtendedLocationPropertyArgs
 *         {
 *             Name = "an",
 *             Type = "CustomLocation",
 *         },
 *         Image = new AzureNative.IoTOperationsMQ.Inputs.ContainerImageArgs
 *         {
 *             PullPolicy = "imfuzvqxgbdwliqnn",
 *             PullSecrets = "klnqimxqsrdwhcqldjvdtsrs",
 *             Repository = "m",
 *             Tag = "jygfdiamhhm",
 *         },
 *         LocalBrokerConnection = new AzureNative.IoTOperationsMQ.Inputs.LocalBrokerConnectionSpecArgs
 *         {
 *             Authentication = new AzureNative.IoTOperationsMQ.Inputs.LocalBrokerAuthenticationMethodsArgs
 *             {
 *                 Kubernetes = new AzureNative.IoTOperationsMQ.Inputs.LocalBrokerKubernetesAuthenticationArgs
 *                 {
 *                     SecretPath = "soukzfkouir",
 *                     ServiceAccountTokenName = "suwetviuhmhorhvsidlznnufe",
 *                 },
 *             },
 *             Endpoint = "xc",
 *             Tls = new AzureNative.IoTOperationsMQ.Inputs.LocalBrokerConnectionTlsArgs
 *             {
 *                 TlsEnabled = true,
 *                 TrustedCaCertificateConfigMap = "rinkomfeznsfedbmllxlbmmhc",
 *             },
 *         },
 *         Location = "frztvxzhskx",
 *         LogLevel = "gpgijsotipdtvvkpnckuziqqv",
 *         MqName = "R8-6x-Y-L-F-21RP5-XVv",
 *         MqttBridgeConnectorName = "k1v-U4P2440C1b7T8y-G",
 *         NodeTolerations = new AzureNative.IoTOperationsMQ.Inputs.NodeTolerationsArgs
 *         {
 *             Effect = "eeswvciblqmmaeesjoflyvxqbz",
 *             Key = "wbrstdwxgm",
 *             Operator = "lbegegneekwnyodtzraarivtwhmzep",
 *             Value = "sfafsjdcezdmkwibxeluukxgl",
 *         },
 *         Protocol = "v3",
 *         RemoteBrokerConnection = new AzureNative.IoTOperationsMQ.Inputs.MqttBridgeRemoteBrokerConnectionSpecArgs
 *         {
 *             Authentication = new AzureNative.IoTOperationsMQ.Inputs.MqttBridgeRemoteBrokerAuthenticationMethodsArgs
 *             {
 *                 SystemAssignedManagedIdentity = new AzureNative.IoTOperationsMQ.Inputs.ManagedIdentityAuthenticationArgs
 *                 {
 *                     Audience = "kjderojhpehosgfcrxxbh",
 *                     ExtensionName = "cyckjqqzspleajbtkniwrfsqygjfhe",
 *                 },
 *                 X509 = new AzureNative.IoTOperationsMQ.Inputs.MqttBridgeRemoteBrokerX509AuthenticationArgs
 *                 {
 *                     KeyVault = new AzureNative.IoTOperationsMQ.Inputs.KeyVaultCertificatePropertiesArgs
 *                     {
 *                         Vault = new AzureNative.IoTOperationsMQ.Inputs.KeyVaultConnectionPropertiesArgs
 *                         {
 *                             Credentials = new AzureNative.IoTOperationsMQ.Inputs.KeyVaultCredentialsPropertiesArgs
 *                             {
 *                                 ServicePrincipalLocalSecretName = "wuimjwpbhoglbsxxa",
 *                             },
 *                             DirectoryId = "eyjniptiykzcgbzok",
 *                             Name = "lxmwfan",
 *                         },
 *                         VaultCaChainSecret = new AzureNative.IoTOperationsMQ.Inputs.KeyVaultSecretObjectArgs
 *                         {
 *                             Name = "bmectskddmpjxnsogwooexj",
 *                             Version = "unjfbf",
 *                         },
 *                         VaultCert = new AzureNative.IoTOperationsMQ.Inputs.KeyVaultSecretObjectArgs
 *                         {
 *                             Name = "bmectskddmpjxnsogwooexj",
 *                             Version = "unjfbf",
 *                         },
 *                     },
 *                     SecretName = "x",
 *                 },
 *             },
 *             Endpoint = "bshzrukafmxjgnrlhzlxbbzjdbqh",
 *             Protocol = "mqtt",
 *             Tls = new AzureNative.IoTOperationsMQ.Inputs.MqttBridgeRemoteBrokerConnectionTlsArgs
 *             {
 *                 TlsEnabled = true,
 *                 TrustedCaCertificateConfigMap = "ivtebqmclgfjx",
 *             },
 *         },
 *         ResourceGroupName = "rgiotoperationsmq",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/iotoperationsmq/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := iotoperationsmq.NewMqttBridgeConnector(ctx, "mqttBridgeConnector", &iotoperationsmq.MqttBridgeConnectorArgs{
 * BridgeInstances: pulumi.Int(4528),
 * ClientIdPrefix: pulumi.String("yqipejvabahsexbnttiegjnh"),
 * ExtendedLocation: &iotoperationsmq.ExtendedLocationPropertyArgs{
 * Name: pulumi.String("an"),
 * Type: pulumi.String("CustomLocation"),
 * },
 * Image: &iotoperationsmq.ContainerImageArgs{
 * PullPolicy: pulumi.String("imfuzvqxgbdwliqnn"),
 * PullSecrets: pulumi.String("klnqimxqsrdwhcqldjvdtsrs"),
 * Repository: pulumi.String("m"),
 * Tag: pulumi.String("jygfdiamhhm"),
 * },
 * LocalBrokerConnection: iotoperationsmq.LocalBrokerConnectionSpecResponse{
 * Authentication: interface{}{
 * Kubernetes: &iotoperationsmq.LocalBrokerKubernetesAuthenticationArgs{
 * SecretPath: pulumi.String("soukzfkouir"),
 * ServiceAccountTokenName: pulumi.String("suwetviuhmhorhvsidlznnufe"),
 * },
 * },
 * Endpoint: pulumi.String("xc"),
 * Tls: &iotoperationsmq.LocalBrokerConnectionTlsArgs{
 * TlsEnabled: pulumi.Bool(true),
 * TrustedCaCertificateConfigMap: pulumi.String("rinkomfeznsfedbmllxlbmmhc"),
 * },
 * },
 * Location: pulumi.String("frztvxzhskx"),
 * LogLevel: pulumi.String("gpgijsotipdtvvkpnckuziqqv"),
 * MqName: pulumi.String("R8-6x-Y-L-F-21RP5-XVv"),
 * MqttBridgeConnectorName: pulumi.String("k1v-U4P2440C1b7T8y-G"),
 * NodeTolerations: &iotoperationsmq.NodeTolerationsArgs{
 * Effect: pulumi.String("eeswvciblqmmaeesjoflyvxqbz"),
 * Key: pulumi.String("wbrstdwxgm"),
 * Operator: pulumi.String("lbegegneekwnyodtzraarivtwhmzep"),
 * Value: pulumi.String("sfafsjdcezdmkwibxeluukxgl"),
 * },
 * Protocol: pulumi.String("v3"),
 * RemoteBrokerConnection: iotoperationsmq.MqttBridgeRemoteBrokerConnectionSpecResponse{
 * Authentication: interface{}{
 * SystemAssignedManagedIdentity: &iotoperationsmq.ManagedIdentityAuthenticationArgs{
 * Audience: pulumi.String("kjderojhpehosgfcrxxbh"),
 * ExtensionName: pulumi.String("cyckjqqzspleajbtkniwrfsqygjfhe"),
 * },
 * X509: interface{}{
 * KeyVault: interface{}{
 * Vault: interface{}{
 * Credentials: &iotoperationsmq.KeyVaultCredentialsPropertiesArgs{
 * ServicePrincipalLocalSecretName: pulumi.String("wuimjwpbhoglbsxxa"),
 * },
 * DirectoryId: pulumi.String("eyjniptiykzcgbzok"),
 * Name: pulumi.String("lxmwfan"),
 * },
 * VaultCaChainSecret: &iotoperationsmq.KeyVaultSecretObjectArgs{
 * Name: pulumi.String("bmectskddmpjxnsogwooexj"),
 * Version: pulumi.String("unjfbf"),
 * },
 * VaultCert: &iotoperationsmq.KeyVaultSecretObjectArgs{
 * Name: pulumi.String("bmectskddmpjxnsogwooexj"),
 * Version: pulumi.String("unjfbf"),
 * },
 * },
 * SecretName: pulumi.String("x"),
 * },
 * },
 * Endpoint: pulumi.String("bshzrukafmxjgnrlhzlxbbzjdbqh"),
 * Protocol: pulumi.String("mqtt"),
 * Tls: &iotoperationsmq.MqttBridgeRemoteBrokerConnectionTlsArgs{
 * TlsEnabled: pulumi.Bool(true),
 * TrustedCaCertificateConfigMap: pulumi.String("ivtebqmclgfjx"),
 * },
 * },
 * ResourceGroupName: pulumi.String("rgiotoperationsmq"),
 * Tags: nil,
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.iotoperationsmq.MqttBridgeConnector;
 * import com.pulumi.azurenative.iotoperationsmq.MqttBridgeConnectorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var mqttBridgeConnector = new MqttBridgeConnector("mqttBridgeConnector", MqttBridgeConnectorArgs.builder()
 *             .bridgeInstances(4528)
 *             .clientIdPrefix("yqipejvabahsexbnttiegjnh")
 *             .extendedLocation(Map.ofEntries(
 *                 Map.entry("name", "an"),
 *                 Map.entry("type", "CustomLocation")
 *             ))
 *             .image(Map.ofEntries(
 *                 Map.entry("pullPolicy", "imfuzvqxgbdwliqnn"),
 *                 Map.entry("pullSecrets", "klnqimxqsrdwhcqldjvdtsrs"),
 *                 Map.entry("repository", "m"),
 *                 Map.entry("tag", "jygfdiamhhm")
 *             ))
 *             .localBrokerConnection(Map.ofEntries(
 *                 Map.entry("authentication", Map.of("kubernetes", Map.ofEntries(
 *                     Map.entry("secretPath", "soukzfkouir"),
 *                     Map.entry("serviceAccountTokenName", "suwetviuhmhorhvsidlznnufe")
 *                 ))),
 *                 Map.entry("endpoint", "xc"),
 *                 Map.entry("tls", Map.ofEntries(
 *                     Map.entry("tlsEnabled", true),
 *                     Map.entry("trustedCaCertificateConfigMap", "rinkomfeznsfedbmllxlbmmhc")
 *                 ))
 *             ))
 *             .location("frztvxzhskx")
 *             .logLevel("gpgijsotipdtvvkpnckuziqqv")
 *             .mqName("R8-6x-Y-L-F-21RP5-XVv")
 *             .mqttBridgeConnectorName("k1v-U4P2440C1b7T8y-G")
 *             .nodeTolerations(Map.ofEntries(
 *                 Map.entry("effect", "eeswvciblqmmaeesjoflyvxqbz"),
 *                 Map.entry("key", "wbrstdwxgm"),
 *                 Map.entry("operator", "lbegegneekwnyodtzraarivtwhmzep"),
 *                 Map.entry("value", "sfafsjdcezdmkwibxeluukxgl")
 *             ))
 *             .protocol("v3")
 *             .remoteBrokerConnection(Map.ofEntries(
 *                 Map.entry("authentication", Map.ofEntries(
 *                     Map.entry("systemAssignedManagedIdentity", Map.ofEntries(
 *                         Map.entry("audience", "kjderojhpehosgfcrxxbh"),
 *                         Map.entry("extensionName", "cyckjqqzspleajbtkniwrfsqygjfhe")
 *                     )),
 *                     Map.entry("x509", Map.ofEntries(
 *                         Map.entry("keyVault", Map.ofEntries(
 *                             Map.entry("vault", Map.ofEntries(
 *                                 Map.entry("credentials", Map.of("servicePrincipalLocalSecretName", "wuimjwpbhoglbsxxa")),
 *                                 Map.entry("directoryId", "eyjniptiykzcgbzok"),
 *                                 Map.entry("name", "lxmwfan")
 *                             )),
 *                             Map.entry("vaultCaChainSecret", Map.ofEntries(
 *                                 Map.entry("name", "bmectskddmpjxnsogwooexj"),
 *                                 Map.entry("version", "unjfbf")
 *                             )),
 *                             Map.entry("vaultCert", Map.ofEntries(
 *                                 Map.entry("name", "bmectskddmpjxnsogwooexj"),
 *                                 Map.entry("version", "unjfbf")
 *                             ))
 *                         )),
 *                         Map.entry("secretName", "x")
 *                     ))
 *                 )),
 *                 Map.entry("endpoint", "bshzrukafmxjgnrlhzlxbbzjdbqh"),
 *                 Map.entry("protocol", "mqtt"),
 *                 Map.entry("tls", Map.ofEntries(
 *                     Map.entry("tlsEnabled", true),
 *                     Map.entry("trustedCaCertificateConfigMap", "ivtebqmclgfjx")
 *                 ))
 *             ))
 *             .resourceGroupName("rgiotoperationsmq")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:iotoperationsmq:MqttBridgeConnector pjcjtrthj /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IoTOperationsMQ/mq/{mqName}/mqttBridgeConnector/{mqttBridgeConnectorName}
 * ```
 */
public class MqttBridgeConnector internal constructor(
    override val javaResource: com.pulumi.azurenative.iotoperationsmq.MqttBridgeConnector,
) : KotlinCustomResource(javaResource, MqttBridgeConnectorMapper) {
    /**
     * The number of instances to deploy for a bridge rollout.
     */
    public val bridgeInstances: Output<Int>?
        get() = javaResource.bridgeInstances().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The client id prefix of the dynamically generated client ids.
     */
    public val clientIdPrefix: Output<String>?
        get() = javaResource.clientIdPrefix().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Extended Location
     */
    public val extendedLocation: Output<ExtendedLocationPropertyResponse>
        get() = javaResource.extendedLocation().applyValue({ args0 ->
            args0.let({ args0 ->
                extendedLocationPropertyResponseToKotlin(args0)
            })
        })

    /**
     * The details of MqttBridge Docker Image.
     */
    public val image: Output<ContainerImageResponse>
        get() = javaResource.image().applyValue({ args0 ->
            args0.let({ args0 ->
                containerImageResponseToKotlin(args0)
            })
        })

    /**
     * The details for connecting with Local Broker.
     */
    public val localBrokerConnection: Output<LocalBrokerConnectionSpecResponse>?
        get() = javaResource.localBrokerConnection().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> localBrokerConnectionSpecResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The log level of the Bridge Connector instances.
     */
    public val logLevel: Output<String>?
        get() = javaResource.logLevel().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The Node Tolerations for the Bridge Connector pods.
     */
    public val nodeTolerations: Output<NodeTolerationsResponse>?
        get() = javaResource.nodeTolerations().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> nodeTolerationsResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The protocol to use for connecting with Brokers.
     */
    public val protocol: Output<String>
        get() = javaResource.protocol().applyValue({ args0 -> args0 })

    /**
     * The status of the last operation.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The details for connecting with Remote Broker.
     */
    public val remoteBrokerConnection: Output<MqttBridgeRemoteBrokerConnectionSpecResponse>
        get() = javaResource.remoteBrokerConnection().applyValue({ args0 ->
            args0.let({ args0 ->
                mqttBridgeRemoteBrokerConnectionSpecResponseToKotlin(args0)
            })
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object MqttBridgeConnectorMapper : ResourceMapper<MqttBridgeConnector> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.iotoperationsmq.MqttBridgeConnector::class == javaResource::class

    override fun map(javaResource: Resource): MqttBridgeConnector = MqttBridgeConnector(
        javaResource
            as com.pulumi.azurenative.iotoperationsmq.MqttBridgeConnector,
    )
}

/**
 * @see [MqttBridgeConnector].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [MqttBridgeConnector].
 */
public suspend fun mqttBridgeConnector(
    name: String,
    block: suspend MqttBridgeConnectorResourceBuilder.() -> Unit,
): MqttBridgeConnector {
    val builder = MqttBridgeConnectorResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [MqttBridgeConnector].
 * @param name The _unique_ name of the resulting resource.
 */
public fun mqttBridgeConnector(name: String): MqttBridgeConnector {
    val builder = MqttBridgeConnectorResourceBuilder()
    builder.name(name)
    return builder.build()
}
