@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin

import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.ExtendedLocationPropertyResponse
import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.MqttBridgeRoutesResponse
import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.ExtendedLocationPropertyResponse.Companion.toKotlin as extendedLocationPropertyResponseToKotlin
import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.MqttBridgeRoutesResponse.Companion.toKotlin as mqttBridgeRoutesResponseToKotlin
import com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [MqttBridgeTopicMap].
 */
@PulumiTagMarker
public class MqttBridgeTopicMapResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: MqttBridgeTopicMapArgs = MqttBridgeTopicMapArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend MqttBridgeTopicMapArgsBuilder.() -> Unit) {
        val builder = MqttBridgeTopicMapArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): MqttBridgeTopicMap {
        val builtJavaResource =
            com.pulumi.azurenative.iotoperationsmq.MqttBridgeTopicMap(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return MqttBridgeTopicMap(builtJavaResource)
    }
}

/**
 * MQ mqttBridgeTopicMap resource
 * Azure REST API version: 2023-10-04-preview.
 * ## Example Usage
 * ### MqttBridgeTopicMap_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var mqttBridgeTopicMap = new AzureNative.IoTOperationsMQ.MqttBridgeTopicMap("mqttBridgeTopicMap", new()
 *     {
 *         ExtendedLocation = new AzureNative.IoTOperationsMQ.Inputs.ExtendedLocationPropertyArgs
 *         {
 *             Name = "an",
 *             Type = "CustomLocation",
 *         },
 *         Location = "icfdftifk",
 *         MqName = "52A1-D1-t--Q7O9-C-2S",
 *         MqttBridgeConnectorName = "5sKfh6461-KDI8h-5",
 *         MqttBridgeConnectorRef = "aemmhvfdzmdtxwgimpaqephgo",
 *         ResourceGroupName = "rgiotoperationsmq",
 *         Routes = new[]
 *         {
 *             new AzureNative.IoTOperationsMQ.Inputs.MqttBridgeRoutesArgs
 *             {
 *                 Direction = "remote-to-local",
 *                 Name = "u",
 *                 Qos = 2,
 *                 SharedSubscription = new AzureNative.IoTOperationsMQ.Inputs.MqttBridgeRouteSharedSubscriptionArgs
 *                 {
 *                     GroupMinimumShareNumber = 129,
 *                     GroupName = "exnfgkdccpuvzqhxrg",
 *                 },
 *                 Source = "xwnfgkkfezlgh",
 *                 Target = "mgwem",
 *             },
 *         },
 *         Tags = null,
 *         TopicMapName = "5--CR4S47--UaxB4-",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/iotoperationsmq/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := iotoperationsmq.NewMqttBridgeTopicMap(ctx, "mqttBridgeTopicMap", &iotoperationsmq.MqttBridgeTopicMapArgs{
 * 			ExtendedLocation: &iotoperationsmq.ExtendedLocationPropertyArgs{
 * 				Name: pulumi.String("an"),
 * 				Type: pulumi.String("CustomLocation"),
 * 			},
 * 			Location:                pulumi.String("icfdftifk"),
 * 			MqName:                  pulumi.String("52A1-D1-t--Q7O9-C-2S"),
 * 			MqttBridgeConnectorName: pulumi.String("5sKfh6461-KDI8h-5"),
 * 			MqttBridgeConnectorRef:  pulumi.String("aemmhvfdzmdtxwgimpaqephgo"),
 * 			ResourceGroupName:       pulumi.String("rgiotoperationsmq"),
 * 			Routes: []iotoperationsmq.MqttBridgeRoutesArgs{
 * 				{
 * 					Direction: pulumi.String("remote-to-local"),
 * 					Name:      pulumi.String("u"),
 * 					Qos:       pulumi.Int(2),
 * 					SharedSubscription: {
 * 						GroupMinimumShareNumber: pulumi.Int(129),
 * 						GroupName:               pulumi.String("exnfgkdccpuvzqhxrg"),
 * 					},
 * 					Source: pulumi.String("xwnfgkkfezlgh"),
 * 					Target: pulumi.String("mgwem"),
 * 				},
 * 			},
 * 			Tags:         nil,
 * 			TopicMapName: pulumi.String("5--CR4S47--UaxB4-"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.iotoperationsmq.MqttBridgeTopicMap;
 * import com.pulumi.azurenative.iotoperationsmq.MqttBridgeTopicMapArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var mqttBridgeTopicMap = new MqttBridgeTopicMap("mqttBridgeTopicMap", MqttBridgeTopicMapArgs.builder()
 *             .extendedLocation(Map.ofEntries(
 *                 Map.entry("name", "an"),
 *                 Map.entry("type", "CustomLocation")
 *             ))
 *             .location("icfdftifk")
 *             .mqName("52A1-D1-t--Q7O9-C-2S")
 *             .mqttBridgeConnectorName("5sKfh6461-KDI8h-5")
 *             .mqttBridgeConnectorRef("aemmhvfdzmdtxwgimpaqephgo")
 *             .resourceGroupName("rgiotoperationsmq")
 *             .routes(Map.ofEntries(
 *                 Map.entry("direction", "remote-to-local"),
 *                 Map.entry("name", "u"),
 *                 Map.entry("qos", 2),
 *                 Map.entry("sharedSubscription", Map.ofEntries(
 *                     Map.entry("groupMinimumShareNumber", 129),
 *                     Map.entry("groupName", "exnfgkdccpuvzqhxrg")
 *                 )),
 *                 Map.entry("source", "xwnfgkkfezlgh"),
 *                 Map.entry("target", "mgwem")
 *             ))
 *             .tags()
 *             .topicMapName("5--CR4S47--UaxB4-")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:iotoperationsmq:MqttBridgeTopicMap vfnttiyszrcrtvwzqwfgeasgwtil /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IoTOperationsMQ/mq/{mqName}/mqttBridgeConnector/{mqttBridgeConnectorName}/topicMap/{topicMapName}
 * ```
 */
public class MqttBridgeTopicMap internal constructor(
    override val javaResource: com.pulumi.azurenative.iotoperationsmq.MqttBridgeTopicMap,
) : KotlinCustomResource(javaResource, MqttBridgeTopicMapMapper) {
    /**
     * Extended Location
     */
    public val extendedLocation: Output<ExtendedLocationPropertyResponse>
        get() = javaResource.extendedLocation().applyValue({ args0 ->
            args0.let({ args0 ->
                extendedLocationPropertyResponseToKotlin(args0)
            })
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The MqttBridgeConnector CRD it refers to.
     */
    public val mqttBridgeConnectorRef: Output<String>
        get() = javaResource.mqttBridgeConnectorRef().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The status of the last operation.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The route details for MqttBridge connector.
     */
    public val routes: Output<List<MqttBridgeRoutesResponse>>?
        get() = javaResource.routes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> mqttBridgeRoutesResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object MqttBridgeTopicMapMapper : ResourceMapper<MqttBridgeTopicMap> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.iotoperationsmq.MqttBridgeTopicMap::class == javaResource::class

    override fun map(javaResource: Resource): MqttBridgeTopicMap = MqttBridgeTopicMap(
        javaResource as
            com.pulumi.azurenative.iotoperationsmq.MqttBridgeTopicMap,
    )
}

/**
 * @see [MqttBridgeTopicMap].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [MqttBridgeTopicMap].
 */
public suspend fun mqttBridgeTopicMap(
    name: String,
    block: suspend MqttBridgeTopicMapResourceBuilder.() -> Unit,
): MqttBridgeTopicMap {
    val builder = MqttBridgeTopicMapResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [MqttBridgeTopicMap].
 * @param name The _unique_ name of the resulting resource.
 */
public fun mqttBridgeTopicMap(name: String): MqttBridgeTopicMap {
    val builder = MqttBridgeTopicMapResourceBuilder()
    builder.name(name)
    return builder.build()
}
