@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin

import com.pulumi.azurenative.iotoperationsmq.MqttBridgeTopicMapArgs.builder
import com.pulumi.azurenative.iotoperationsmq.kotlin.inputs.ExtendedLocationPropertyArgs
import com.pulumi.azurenative.iotoperationsmq.kotlin.inputs.ExtendedLocationPropertyArgsBuilder
import com.pulumi.azurenative.iotoperationsmq.kotlin.inputs.MqttBridgeRoutesArgs
import com.pulumi.azurenative.iotoperationsmq.kotlin.inputs.MqttBridgeRoutesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * MQ mqttBridgeTopicMap resource
 * Azure REST API version: 2023-10-04-preview.
 * ## Example Usage
 * ### MqttBridgeTopicMap_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var mqttBridgeTopicMap = new AzureNative.IoTOperationsMQ.MqttBridgeTopicMap("mqttBridgeTopicMap", new()
 *     {
 *         ExtendedLocation = new AzureNative.IoTOperationsMQ.Inputs.ExtendedLocationPropertyArgs
 *         {
 *             Name = "an",
 *             Type = "CustomLocation",
 *         },
 *         Location = "icfdftifk",
 *         MqName = "52A1-D1-t--Q7O9-C-2S",
 *         MqttBridgeConnectorName = "5sKfh6461-KDI8h-5",
 *         MqttBridgeConnectorRef = "aemmhvfdzmdtxwgimpaqephgo",
 *         ResourceGroupName = "rgiotoperationsmq",
 *         Routes = new[]
 *         {
 *             new AzureNative.IoTOperationsMQ.Inputs.MqttBridgeRoutesArgs
 *             {
 *                 Direction = "remote-to-local",
 *                 Name = "u",
 *                 Qos = 2,
 *                 SharedSubscription = new AzureNative.IoTOperationsMQ.Inputs.MqttBridgeRouteSharedSubscriptionArgs
 *                 {
 *                     GroupMinimumShareNumber = 129,
 *                     GroupName = "exnfgkdccpuvzqhxrg",
 *                 },
 *                 Source = "xwnfgkkfezlgh",
 *                 Target = "mgwem",
 *             },
 *         },
 *         Tags = null,
 *         TopicMapName = "5--CR4S47--UaxB4-",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/iotoperationsmq/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := iotoperationsmq.NewMqttBridgeTopicMap(ctx, "mqttBridgeTopicMap", &iotoperationsmq.MqttBridgeTopicMapArgs{
 * 			ExtendedLocation: &iotoperationsmq.ExtendedLocationPropertyArgs{
 * 				Name: pulumi.String("an"),
 * 				Type: pulumi.String("CustomLocation"),
 * 			},
 * 			Location:                pulumi.String("icfdftifk"),
 * 			MqName:                  pulumi.String("52A1-D1-t--Q7O9-C-2S"),
 * 			MqttBridgeConnectorName: pulumi.String("5sKfh6461-KDI8h-5"),
 * 			MqttBridgeConnectorRef:  pulumi.String("aemmhvfdzmdtxwgimpaqephgo"),
 * 			ResourceGroupName:       pulumi.String("rgiotoperationsmq"),
 * 			Routes: []iotoperationsmq.MqttBridgeRoutesArgs{
 * 				{
 * 					Direction: pulumi.String("remote-to-local"),
 * 					Name:      pulumi.String("u"),
 * 					Qos:       pulumi.Int(2),
 * 					SharedSubscription: {
 * 						GroupMinimumShareNumber: pulumi.Int(129),
 * 						GroupName:               pulumi.String("exnfgkdccpuvzqhxrg"),
 * 					},
 * 					Source: pulumi.String("xwnfgkkfezlgh"),
 * 					Target: pulumi.String("mgwem"),
 * 				},
 * 			},
 * 			Tags:         nil,
 * 			TopicMapName: pulumi.String("5--CR4S47--UaxB4-"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.iotoperationsmq.MqttBridgeTopicMap;
 * import com.pulumi.azurenative.iotoperationsmq.MqttBridgeTopicMapArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var mqttBridgeTopicMap = new MqttBridgeTopicMap("mqttBridgeTopicMap", MqttBridgeTopicMapArgs.builder()
 *             .extendedLocation(Map.ofEntries(
 *                 Map.entry("name", "an"),
 *                 Map.entry("type", "CustomLocation")
 *             ))
 *             .location("icfdftifk")
 *             .mqName("52A1-D1-t--Q7O9-C-2S")
 *             .mqttBridgeConnectorName("5sKfh6461-KDI8h-5")
 *             .mqttBridgeConnectorRef("aemmhvfdzmdtxwgimpaqephgo")
 *             .resourceGroupName("rgiotoperationsmq")
 *             .routes(Map.ofEntries(
 *                 Map.entry("direction", "remote-to-local"),
 *                 Map.entry("name", "u"),
 *                 Map.entry("qos", 2),
 *                 Map.entry("sharedSubscription", Map.ofEntries(
 *                     Map.entry("groupMinimumShareNumber", 129),
 *                     Map.entry("groupName", "exnfgkdccpuvzqhxrg")
 *                 )),
 *                 Map.entry("source", "xwnfgkkfezlgh"),
 *                 Map.entry("target", "mgwem")
 *             ))
 *             .tags()
 *             .topicMapName("5--CR4S47--UaxB4-")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:iotoperationsmq:MqttBridgeTopicMap vfnttiyszrcrtvwzqwfgeasgwtil /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.IoTOperationsMQ/mq/{mqName}/mqttBridgeConnector/{mqttBridgeConnectorName}/topicMap/{topicMapName}
 * ```
 * @property extendedLocation Extended Location
 * @property location The geo-location where the resource lives
 * @property mqName Name of MQ resource
 * @property mqttBridgeConnectorName Name of MQ mqttBridgeConnector resource
 * @property mqttBridgeConnectorRef The MqttBridgeConnector CRD it refers to.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property routes The route details for MqttBridge connector.
 * @property tags Resource tags.
 * @property topicMapName Name of MQ mqttBridgeTopicMap resource
 */
public data class MqttBridgeTopicMapArgs(
    public val extendedLocation: Output<ExtendedLocationPropertyArgs>? = null,
    public val location: Output<String>? = null,
    public val mqName: Output<String>? = null,
    public val mqttBridgeConnectorName: Output<String>? = null,
    public val mqttBridgeConnectorRef: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val routes: Output<List<MqttBridgeRoutesArgs>>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val topicMapName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.iotoperationsmq.MqttBridgeTopicMapArgs> {
    override fun toJava(): com.pulumi.azurenative.iotoperationsmq.MqttBridgeTopicMapArgs =
        com.pulumi.azurenative.iotoperationsmq.MqttBridgeTopicMapArgs.builder()
            .extendedLocation(extendedLocation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .mqName(mqName?.applyValue({ args0 -> args0 }))
            .mqttBridgeConnectorName(mqttBridgeConnectorName?.applyValue({ args0 -> args0 }))
            .mqttBridgeConnectorRef(mqttBridgeConnectorRef?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .routes(routes?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .topicMapName(topicMapName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MqttBridgeTopicMapArgs].
 */
@PulumiTagMarker
public class MqttBridgeTopicMapArgsBuilder internal constructor() {
    private var extendedLocation: Output<ExtendedLocationPropertyArgs>? = null

    private var location: Output<String>? = null

    private var mqName: Output<String>? = null

    private var mqttBridgeConnectorName: Output<String>? = null

    private var mqttBridgeConnectorRef: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var routes: Output<List<MqttBridgeRoutesArgs>>? = null

    private var tags: Output<Map<String, String>>? = null

    private var topicMapName: Output<String>? = null

    /**
     * @param value Extended Location
     */
    @JvmName("bmremdxojjevpghc")
    public suspend fun extendedLocation(`value`: Output<ExtendedLocationPropertyArgs>) {
        this.extendedLocation = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("kxsmfatxwdrdgxyq")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Name of MQ resource
     */
    @JvmName("uflnnlokfqwkewrh")
    public suspend fun mqName(`value`: Output<String>) {
        this.mqName = value
    }

    /**
     * @param value Name of MQ mqttBridgeConnector resource
     */
    @JvmName("mudqdffnqoonkclh")
    public suspend fun mqttBridgeConnectorName(`value`: Output<String>) {
        this.mqttBridgeConnectorName = value
    }

    /**
     * @param value The MqttBridgeConnector CRD it refers to.
     */
    @JvmName("gcwggtteymhfnqkl")
    public suspend fun mqttBridgeConnectorRef(`value`: Output<String>) {
        this.mqttBridgeConnectorRef = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("dibnrkuaemarwubn")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The route details for MqttBridge connector.
     */
    @JvmName("kdreqnddqwdstosy")
    public suspend fun routes(`value`: Output<List<MqttBridgeRoutesArgs>>) {
        this.routes = value
    }

    @JvmName("laxlngamebqqogui")
    public suspend fun routes(vararg values: Output<MqttBridgeRoutesArgs>) {
        this.routes = Output.all(values.asList())
    }

    /**
     * @param values The route details for MqttBridge connector.
     */
    @JvmName("ixuqwqltxfbvqasi")
    public suspend fun routes(values: List<Output<MqttBridgeRoutesArgs>>) {
        this.routes = Output.all(values)
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("lqjbtcnaccoaueca")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Name of MQ mqttBridgeTopicMap resource
     */
    @JvmName("qtahcqeihsyofahj")
    public suspend fun topicMapName(`value`: Output<String>) {
        this.topicMapName = value
    }

    /**
     * @param value Extended Location
     */
    @JvmName("mawnrxprlcyrmcyf")
    public suspend fun extendedLocation(`value`: ExtendedLocationPropertyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extendedLocation = mapped
    }

    /**
     * @param argument Extended Location
     */
    @JvmName("mwqeryrpumhcjfje")
    public suspend
    fun extendedLocation(argument: suspend ExtendedLocationPropertyArgsBuilder.() -> Unit) {
        val toBeMapped = ExtendedLocationPropertyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.extendedLocation = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("utdgosobeypfeivl")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Name of MQ resource
     */
    @JvmName("jknpmpouektsmfhn")
    public suspend fun mqName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mqName = mapped
    }

    /**
     * @param value Name of MQ mqttBridgeConnector resource
     */
    @JvmName("bambrywrspkowfhx")
    public suspend fun mqttBridgeConnectorName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mqttBridgeConnectorName = mapped
    }

    /**
     * @param value The MqttBridgeConnector CRD it refers to.
     */
    @JvmName("hymrwglbujocfxex")
    public suspend fun mqttBridgeConnectorRef(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mqttBridgeConnectorRef = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("cfbfabnvvmplohpj")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The route details for MqttBridge connector.
     */
    @JvmName("xcvwyryxajogjtnk")
    public suspend fun routes(`value`: List<MqttBridgeRoutesArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routes = mapped
    }

    /**
     * @param argument The route details for MqttBridge connector.
     */
    @JvmName("cclxnjbpghcdvhcm")
    public suspend fun routes(argument: List<suspend MqttBridgeRoutesArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            MqttBridgeRoutesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.routes = mapped
    }

    /**
     * @param argument The route details for MqttBridge connector.
     */
    @JvmName("limjbwrrylwllivi")
    public suspend fun routes(vararg argument: suspend MqttBridgeRoutesArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            MqttBridgeRoutesArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.routes = mapped
    }

    /**
     * @param argument The route details for MqttBridge connector.
     */
    @JvmName("scifroylrgeulwmm")
    public suspend fun routes(argument: suspend MqttBridgeRoutesArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(MqttBridgeRoutesArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.routes = mapped
    }

    /**
     * @param values The route details for MqttBridge connector.
     */
    @JvmName("hjyjcrljitvassdi")
    public suspend fun routes(vararg values: MqttBridgeRoutesArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.routes = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("bsghuufwogfckghq")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("rlmqnnumcvumoqgu")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Name of MQ mqttBridgeTopicMap resource
     */
    @JvmName("xxucqferfswuiqxf")
    public suspend fun topicMapName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.topicMapName = mapped
    }

    internal fun build(): MqttBridgeTopicMapArgs = MqttBridgeTopicMapArgs(
        extendedLocation = extendedLocation,
        location = location,
        mqName = mqName,
        mqttBridgeConnectorName = mqttBridgeConnectorName,
        mqttBridgeConnectorRef = mqttBridgeConnectorRef,
        resourceGroupName = resourceGroupName,
        routes = routes,
        tags = tags,
        topicMapName = topicMapName,
    )
}
