@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The Running Mode of the Broker Deployment.
 */
public enum class RunMode(
    public val javaValue: com.pulumi.azurenative.iotoperationsmq.enums.RunMode,
) : ConvertibleToJava<com.pulumi.azurenative.iotoperationsmq.enums.RunMode> {
    /**
     * Automatically provision Frontend and Backend pods.
     */
    Auto(com.pulumi.azurenative.iotoperationsmq.enums.RunMode.Auto),

    /**
     * Use Cardinality to set Frontend and Backend pods.
     */
    Distributed(com.pulumi.azurenative.iotoperationsmq.enums.RunMode.Distributed),
    ;

    override fun toJava(): com.pulumi.azurenative.iotoperationsmq.enums.RunMode = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.iotoperationsmq.enums.RunMode): RunMode =
            RunMode.values().first { it.javaValue == javaType }
    }
}
