@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.inputs

import com.pulumi.azurenative.iotoperationsmq.inputs.AuthorizationBasicRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * BasicRules of AuthorizationConfig Polar rules are not supported
 * @property brokerResources This subfield defines the broker resources that the Basic Rule is applied on.
 * @property principals This subfield defines the identities that represent the clients.
 */
public data class AuthorizationBasicRuleArgs(
    public val brokerResources: Output<List<ResourceInfoDefinitionArgs>>,
    public val principals: Output<PrincipalDefinitionArgs>,
) : ConvertibleToJava<com.pulumi.azurenative.iotoperationsmq.inputs.AuthorizationBasicRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.iotoperationsmq.inputs.AuthorizationBasicRuleArgs =
        com.pulumi.azurenative.iotoperationsmq.inputs.AuthorizationBasicRuleArgs.builder()
            .brokerResources(
                brokerResources.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .principals(principals.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [AuthorizationBasicRuleArgs].
 */
@PulumiTagMarker
public class AuthorizationBasicRuleArgsBuilder internal constructor() {
    private var brokerResources: Output<List<ResourceInfoDefinitionArgs>>? = null

    private var principals: Output<PrincipalDefinitionArgs>? = null

    /**
     * @param value This subfield defines the broker resources that the Basic Rule is applied on.
     */
    @JvmName("pqyjugihvbjlnkqy")
    public suspend fun brokerResources(`value`: Output<List<ResourceInfoDefinitionArgs>>) {
        this.brokerResources = value
    }

    @JvmName("bfkiusrltbiycxoj")
    public suspend fun brokerResources(vararg values: Output<ResourceInfoDefinitionArgs>) {
        this.brokerResources = Output.all(values.asList())
    }

    /**
     * @param values This subfield defines the broker resources that the Basic Rule is applied on.
     */
    @JvmName("vqhikhfdyaobcyli")
    public suspend fun brokerResources(values: List<Output<ResourceInfoDefinitionArgs>>) {
        this.brokerResources = Output.all(values)
    }

    /**
     * @param value This subfield defines the identities that represent the clients.
     */
    @JvmName("jiwolmeoxkvbvyvv")
    public suspend fun principals(`value`: Output<PrincipalDefinitionArgs>) {
        this.principals = value
    }

    /**
     * @param value This subfield defines the broker resources that the Basic Rule is applied on.
     */
    @JvmName("kiomuajsytcsfhgy")
    public suspend fun brokerResources(`value`: List<ResourceInfoDefinitionArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.brokerResources = mapped
    }

    /**
     * @param argument This subfield defines the broker resources that the Basic Rule is applied on.
     */
    @JvmName("mtyyhbtdqkkfamsh")
    public suspend
    fun brokerResources(argument: List<suspend ResourceInfoDefinitionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ResourceInfoDefinitionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.brokerResources = mapped
    }

    /**
     * @param argument This subfield defines the broker resources that the Basic Rule is applied on.
     */
    @JvmName("pkglcxoicecmpgxw")
    public suspend fun brokerResources(
        vararg
        argument: suspend ResourceInfoDefinitionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ResourceInfoDefinitionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.brokerResources = mapped
    }

    /**
     * @param argument This subfield defines the broker resources that the Basic Rule is applied on.
     */
    @JvmName("npyfyrkfdegjbwep")
    public suspend
    fun brokerResources(argument: suspend ResourceInfoDefinitionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ResourceInfoDefinitionArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.brokerResources = mapped
    }

    /**
     * @param values This subfield defines the broker resources that the Basic Rule is applied on.
     */
    @JvmName("gsnswcqrlaaxewfu")
    public suspend fun brokerResources(vararg values: ResourceInfoDefinitionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.brokerResources = mapped
    }

    /**
     * @param value This subfield defines the identities that represent the clients.
     */
    @JvmName("qsnxdwbqanuppyln")
    public suspend fun principals(`value`: PrincipalDefinitionArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.principals = mapped
    }

    /**
     * @param argument This subfield defines the identities that represent the clients.
     */
    @JvmName("mlbutokwaajttgvp")
    public suspend fun principals(argument: suspend PrincipalDefinitionArgsBuilder.() -> Unit) {
        val toBeMapped = PrincipalDefinitionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.principals = mapped
    }

    internal fun build(): AuthorizationBasicRuleArgs = AuthorizationBasicRuleArgs(
        brokerResources = brokerResources ?: throw PulumiNullFieldException("brokerResources"),
        principals = principals ?: throw PulumiNullFieldException("principals"),
    )
}
