@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.inputs

import com.pulumi.azurenative.iotoperationsmq.inputs.BrokerAuthenticatorMethodCustomArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Custom method for BrokerAuthentication
 * @property auth Custom Broker Authentication Method.
 * @property caCertConfigMap CA cert config map to use.
 * @property endpoint Endpoint to connect to.
 * @property headers Configuration Headers to use.
 */
public data class BrokerAuthenticatorMethodCustomArgs(
    public val auth: Output<BrokerAuthenticatorCustomAuthArgs>? = null,
    public val caCertConfigMap: Output<String>? = null,
    public val endpoint: Output<String>,
    public val headers: Output<Map<String, String>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.iotoperationsmq.inputs.BrokerAuthenticatorMethodCustomArgs> {
    override fun toJava():
        com.pulumi.azurenative.iotoperationsmq.inputs.BrokerAuthenticatorMethodCustomArgs =
        com.pulumi.azurenative.iotoperationsmq.inputs.BrokerAuthenticatorMethodCustomArgs.builder()
            .auth(auth?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .caCertConfigMap(caCertConfigMap?.applyValue({ args0 -> args0 }))
            .endpoint(endpoint.applyValue({ args0 -> args0 }))
            .headers(
                headers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [BrokerAuthenticatorMethodCustomArgs].
 */
@PulumiTagMarker
public class BrokerAuthenticatorMethodCustomArgsBuilder internal constructor() {
    private var auth: Output<BrokerAuthenticatorCustomAuthArgs>? = null

    private var caCertConfigMap: Output<String>? = null

    private var endpoint: Output<String>? = null

    private var headers: Output<Map<String, String>>? = null

    /**
     * @param value Custom Broker Authentication Method.
     */
    @JvmName("fcvnbhfjfqcugubk")
    public suspend fun auth(`value`: Output<BrokerAuthenticatorCustomAuthArgs>) {
        this.auth = value
    }

    /**
     * @param value CA cert config map to use.
     */
    @JvmName("fojkxlylefpmtban")
    public suspend fun caCertConfigMap(`value`: Output<String>) {
        this.caCertConfigMap = value
    }

    /**
     * @param value Endpoint to connect to.
     */
    @JvmName("eqtkrsgnvxltwrsp")
    public suspend fun endpoint(`value`: Output<String>) {
        this.endpoint = value
    }

    /**
     * @param value Configuration Headers to use.
     */
    @JvmName("yyfexiucrndlxdxm")
    public suspend fun headers(`value`: Output<Map<String, String>>) {
        this.headers = value
    }

    /**
     * @param value Custom Broker Authentication Method.
     */
    @JvmName("gdvwwqnhseqyqopb")
    public suspend fun auth(`value`: BrokerAuthenticatorCustomAuthArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.auth = mapped
    }

    /**
     * @param argument Custom Broker Authentication Method.
     */
    @JvmName("kxehfsdpkwqgrjas")
    public suspend fun auth(argument: suspend BrokerAuthenticatorCustomAuthArgsBuilder.() -> Unit) {
        val toBeMapped = BrokerAuthenticatorCustomAuthArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.auth = mapped
    }

    /**
     * @param value CA cert config map to use.
     */
    @JvmName("kujblebvmqmlubwb")
    public suspend fun caCertConfigMap(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.caCertConfigMap = mapped
    }

    /**
     * @param value Endpoint to connect to.
     */
    @JvmName("uaydgwgchvfsbbsc")
    public suspend fun endpoint(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.endpoint = mapped
    }

    /**
     * @param value Configuration Headers to use.
     */
    @JvmName("fwtfwproryfodplk")
    public suspend fun headers(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.headers = mapped
    }

    /**
     * @param values Configuration Headers to use.
     */
    @JvmName("tdwyiqwgwixxffag")
    public fun headers(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.headers = mapped
    }

    internal fun build(): BrokerAuthenticatorMethodCustomArgs = BrokerAuthenticatorMethodCustomArgs(
        auth = auth,
        caCertConfigMap = caCertConfigMap,
        endpoint = endpoint ?: throw PulumiNullFieldException("endpoint"),
        headers = headers,
    )
}
