@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.inputs

import com.pulumi.azurenative.iotoperationsmq.inputs.BrokerAuthenticatorMethodX509Args.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * X509 for BrokerAuthentication.
 * @property attributes K8S Secret name to mount for username and password.
 * @property trustedClientCaCertConfigMap Trusted client ca cert config map.
 */
public data class BrokerAuthenticatorMethodX509Args(
    public val attributes: Output<BrokerAuthenticatorMethodX509AttributesArgs>? = null,
    public val trustedClientCaCertConfigMap: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.iotoperationsmq.inputs.BrokerAuthenticatorMethodX509Args> {
    override fun toJava():
        com.pulumi.azurenative.iotoperationsmq.inputs.BrokerAuthenticatorMethodX509Args =
        com.pulumi.azurenative.iotoperationsmq.inputs.BrokerAuthenticatorMethodX509Args.builder()
            .attributes(attributes?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .trustedClientCaCertConfigMap(trustedClientCaCertConfigMap?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BrokerAuthenticatorMethodX509Args].
 */
@PulumiTagMarker
public class BrokerAuthenticatorMethodX509ArgsBuilder internal constructor() {
    private var attributes: Output<BrokerAuthenticatorMethodX509AttributesArgs>? = null

    private var trustedClientCaCertConfigMap: Output<String>? = null

    /**
     * @param value K8S Secret name to mount for username and password.
     */
    @JvmName("whwjlesenvdgathf")
    public suspend fun attributes(`value`: Output<BrokerAuthenticatorMethodX509AttributesArgs>) {
        this.attributes = value
    }

    /**
     * @param value Trusted client ca cert config map.
     */
    @JvmName("unobskyouasfxdot")
    public suspend fun trustedClientCaCertConfigMap(`value`: Output<String>) {
        this.trustedClientCaCertConfigMap = value
    }

    /**
     * @param value K8S Secret name to mount for username and password.
     */
    @JvmName("dvpcujpbydkejkpy")
    public suspend fun attributes(`value`: BrokerAuthenticatorMethodX509AttributesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.attributes = mapped
    }

    /**
     * @param argument K8S Secret name to mount for username and password.
     */
    @JvmName("aacijnpesqanbnhn")
    public suspend
    fun attributes(argument: suspend BrokerAuthenticatorMethodX509AttributesArgsBuilder.() -> Unit) {
        val toBeMapped = BrokerAuthenticatorMethodX509AttributesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.attributes = mapped
    }

    /**
     * @param value Trusted client ca cert config map.
     */
    @JvmName("wgrnaggfeulwkwgg")
    public suspend fun trustedClientCaCertConfigMap(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trustedClientCaCertConfigMap = mapped
    }

    internal fun build(): BrokerAuthenticatorMethodX509Args = BrokerAuthenticatorMethodX509Args(
        attributes = attributes,
        trustedClientCaCertConfigMap = trustedClientCaCertConfigMap,
    )
}
