@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.inputs

import com.pulumi.azurenative.iotoperationsmq.inputs.BrokerAuthenticatorMethodsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Collection of different CrdAuthenticator methods of Broker Resource. NOTE Enum - Only one method is supported for each entry.
 * @property custom Custom Authentication Method.
 * @property sat Service Account Token Method.
 * @property svid Service Account Token Method.
 * @property usernamePassword UsernamePassword Method.
 * @property x509 X509 Method.
 */
public data class BrokerAuthenticatorMethodsArgs(
    public val custom: Output<BrokerAuthenticatorMethodCustomArgs>? = null,
    public val sat: Output<BrokerAuthenticatorMethodSatArgs>? = null,
    public val svid: Output<BrokerAuthenticatorMethodSvidArgs>? = null,
    public val usernamePassword: Output<BrokerAuthenticatorMethodUsernamePasswordArgs>? = null,
    public val x509: Output<BrokerAuthenticatorMethodX509Args>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.iotoperationsmq.inputs.BrokerAuthenticatorMethodsArgs> {
    override fun toJava():
        com.pulumi.azurenative.iotoperationsmq.inputs.BrokerAuthenticatorMethodsArgs =
        com.pulumi.azurenative.iotoperationsmq.inputs.BrokerAuthenticatorMethodsArgs.builder()
            .custom(custom?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .sat(sat?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .svid(svid?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .usernamePassword(usernamePassword?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .x509(x509?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [BrokerAuthenticatorMethodsArgs].
 */
@PulumiTagMarker
public class BrokerAuthenticatorMethodsArgsBuilder internal constructor() {
    private var custom: Output<BrokerAuthenticatorMethodCustomArgs>? = null

    private var sat: Output<BrokerAuthenticatorMethodSatArgs>? = null

    private var svid: Output<BrokerAuthenticatorMethodSvidArgs>? = null

    private var usernamePassword: Output<BrokerAuthenticatorMethodUsernamePasswordArgs>? = null

    private var x509: Output<BrokerAuthenticatorMethodX509Args>? = null

    /**
     * @param value Custom Authentication Method.
     */
    @JvmName("pdivhlqpexbvdgpi")
    public suspend fun custom(`value`: Output<BrokerAuthenticatorMethodCustomArgs>) {
        this.custom = value
    }

    /**
     * @param value Service Account Token Method.
     */
    @JvmName("kqmgmhjqkdmlmamh")
    public suspend fun sat(`value`: Output<BrokerAuthenticatorMethodSatArgs>) {
        this.sat = value
    }

    /**
     * @param value Service Account Token Method.
     */
    @JvmName("uhnspnpiveiyflkn")
    public suspend fun svid(`value`: Output<BrokerAuthenticatorMethodSvidArgs>) {
        this.svid = value
    }

    /**
     * @param value UsernamePassword Method.
     */
    @JvmName("cjjddynavltwxuqr")
    public suspend
    fun usernamePassword(`value`: Output<BrokerAuthenticatorMethodUsernamePasswordArgs>) {
        this.usernamePassword = value
    }

    /**
     * @param value X509 Method.
     */
    @JvmName("kxkckdohklqktajx")
    public suspend fun x509(`value`: Output<BrokerAuthenticatorMethodX509Args>) {
        this.x509 = value
    }

    /**
     * @param value Custom Authentication Method.
     */
    @JvmName("ogysteoyrflelewx")
    public suspend fun custom(`value`: BrokerAuthenticatorMethodCustomArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.custom = mapped
    }

    /**
     * @param argument Custom Authentication Method.
     */
    @JvmName("ybqniyxtqcwcmnbq")
    public suspend
    fun custom(argument: suspend BrokerAuthenticatorMethodCustomArgsBuilder.() -> Unit) {
        val toBeMapped = BrokerAuthenticatorMethodCustomArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.custom = mapped
    }

    /**
     * @param value Service Account Token Method.
     */
    @JvmName("kouwelixtyamuham")
    public suspend fun sat(`value`: BrokerAuthenticatorMethodSatArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sat = mapped
    }

    /**
     * @param argument Service Account Token Method.
     */
    @JvmName("jpkybdxvlpteiyqw")
    public suspend fun sat(argument: suspend BrokerAuthenticatorMethodSatArgsBuilder.() -> Unit) {
        val toBeMapped = BrokerAuthenticatorMethodSatArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sat = mapped
    }

    /**
     * @param value Service Account Token Method.
     */
    @JvmName("ywlbvkhqpbahqnxk")
    public suspend fun svid(`value`: BrokerAuthenticatorMethodSvidArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.svid = mapped
    }

    /**
     * @param argument Service Account Token Method.
     */
    @JvmName("aislavucwbfxqmpl")
    public suspend fun svid(argument: suspend BrokerAuthenticatorMethodSvidArgsBuilder.() -> Unit) {
        val toBeMapped = BrokerAuthenticatorMethodSvidArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.svid = mapped
    }

    /**
     * @param value UsernamePassword Method.
     */
    @JvmName("fkejviaphymdisfe")
    public suspend fun usernamePassword(`value`: BrokerAuthenticatorMethodUsernamePasswordArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.usernamePassword = mapped
    }

    /**
     * @param argument UsernamePassword Method.
     */
    @JvmName("dfsetlewhxmxkolc")
    public suspend
    fun usernamePassword(argument: suspend BrokerAuthenticatorMethodUsernamePasswordArgsBuilder.() -> Unit) {
        val toBeMapped = BrokerAuthenticatorMethodUsernamePasswordArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.usernamePassword = mapped
    }

    /**
     * @param value X509 Method.
     */
    @JvmName("aymobfafyfgwxdhq")
    public suspend fun x509(`value`: BrokerAuthenticatorMethodX509Args?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.x509 = mapped
    }

    /**
     * @param argument X509 Method.
     */
    @JvmName("dmdbecguuqdncale")
    public suspend fun x509(argument: suspend BrokerAuthenticatorMethodX509ArgsBuilder.() -> Unit) {
        val toBeMapped = BrokerAuthenticatorMethodX509ArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.x509 = mapped
    }

    internal fun build(): BrokerAuthenticatorMethodsArgs = BrokerAuthenticatorMethodsArgs(
        custom = custom,
        sat = sat,
        svid = svid,
        usernamePassword = usernamePassword,
        x509 = x509,
    )
}
