@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.inputs

import com.pulumi.azurenative.iotoperationsmq.inputs.DataLakeFabricStorageArgs.builder
import com.pulumi.azurenative.iotoperationsmq.kotlin.enums.FabricPathType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * DataLake Fabric Storage details.
 * @property authentication DataLake fabric storage authentication details.
 * @property endpoint DataLake fabric storage endpoint to use.
 * @property fabricPath Fabric path type to use.
 * @property guids Fabric one lake Guids.
 * @property names Fabric one lake Names.
 */
public data class DataLakeFabricStorageArgs(
    public val authentication: Output<DataLakeFabricStorageAuthenticationArgs>,
    public val endpoint: Output<String>,
    public val fabricPath: Output<Either<String, FabricPathType>>,
    public val guids: Output<FabricGuidsArgs>? = null,
    public val names: Output<FabricNamesArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.iotoperationsmq.inputs.DataLakeFabricStorageArgs> {
    override fun toJava(): com.pulumi.azurenative.iotoperationsmq.inputs.DataLakeFabricStorageArgs =
        com.pulumi.azurenative.iotoperationsmq.inputs.DataLakeFabricStorageArgs.builder()
            .authentication(authentication.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .endpoint(endpoint.applyValue({ args0 -> args0 }))
            .fabricPath(
                fabricPath.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .guids(guids?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .names(names?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [DataLakeFabricStorageArgs].
 */
@PulumiTagMarker
public class DataLakeFabricStorageArgsBuilder internal constructor() {
    private var authentication: Output<DataLakeFabricStorageAuthenticationArgs>? = null

    private var endpoint: Output<String>? = null

    private var fabricPath: Output<Either<String, FabricPathType>>? = null

    private var guids: Output<FabricGuidsArgs>? = null

    private var names: Output<FabricNamesArgs>? = null

    /**
     * @param value DataLake fabric storage authentication details.
     */
    @JvmName("ttiyaeicfattegwv")
    public suspend fun authentication(`value`: Output<DataLakeFabricStorageAuthenticationArgs>) {
        this.authentication = value
    }

    /**
     * @param value DataLake fabric storage endpoint to use.
     */
    @JvmName("wkebchyastxkjxss")
    public suspend fun endpoint(`value`: Output<String>) {
        this.endpoint = value
    }

    /**
     * @param value Fabric path type to use.
     */
    @JvmName("rfrwvlbdgliqcwwq")
    public suspend fun fabricPath(`value`: Output<Either<String, FabricPathType>>) {
        this.fabricPath = value
    }

    /**
     * @param value Fabric one lake Guids.
     */
    @JvmName("jgmfatpgmnrrpqqe")
    public suspend fun guids(`value`: Output<FabricGuidsArgs>) {
        this.guids = value
    }

    /**
     * @param value Fabric one lake Names.
     */
    @JvmName("mkuaqwfpktygqodf")
    public suspend fun names(`value`: Output<FabricNamesArgs>) {
        this.names = value
    }

    /**
     * @param value DataLake fabric storage authentication details.
     */
    @JvmName("xmrimeyytscrstth")
    public suspend fun authentication(`value`: DataLakeFabricStorageAuthenticationArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authentication = mapped
    }

    /**
     * @param argument DataLake fabric storage authentication details.
     */
    @JvmName("idooebgenaxrcalb")
    public suspend
    fun authentication(argument: suspend DataLakeFabricStorageAuthenticationArgsBuilder.() -> Unit) {
        val toBeMapped = DataLakeFabricStorageAuthenticationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.authentication = mapped
    }

    /**
     * @param value DataLake fabric storage endpoint to use.
     */
    @JvmName("jiqgrcsuemdlmybq")
    public suspend fun endpoint(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.endpoint = mapped
    }

    /**
     * @param value Fabric path type to use.
     */
    @JvmName("scyhdbefyisscohx")
    public suspend fun fabricPath(`value`: Either<String, FabricPathType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.fabricPath = mapped
    }

    /**
     * @param value Fabric path type to use.
     */
    @JvmName("opbhjpodssqfgbjf")
    public fun fabricPath(`value`: String) {
        val toBeMapped = Either.ofLeft<String, FabricPathType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.fabricPath = mapped
    }

    /**
     * @param value Fabric path type to use.
     */
    @JvmName("ygxjikklifjvyavq")
    public fun fabricPath(`value`: FabricPathType) {
        val toBeMapped = Either.ofRight<String, FabricPathType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.fabricPath = mapped
    }

    /**
     * @param value Fabric one lake Guids.
     */
    @JvmName("ikshvihxupgaqjhn")
    public suspend fun guids(`value`: FabricGuidsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.guids = mapped
    }

    /**
     * @param argument Fabric one lake Guids.
     */
    @JvmName("gfaylertdxmtvltj")
    public suspend fun guids(argument: suspend FabricGuidsArgsBuilder.() -> Unit) {
        val toBeMapped = FabricGuidsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.guids = mapped
    }

    /**
     * @param value Fabric one lake Names.
     */
    @JvmName("flwnkfkklkkmcklp")
    public suspend fun names(`value`: FabricNamesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.names = mapped
    }

    /**
     * @param argument Fabric one lake Names.
     */
    @JvmName("anhhheqddjkqsfrn")
    public suspend fun names(argument: suspend FabricNamesArgsBuilder.() -> Unit) {
        val toBeMapped = FabricNamesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.names = mapped
    }

    internal fun build(): DataLakeFabricStorageArgs = DataLakeFabricStorageArgs(
        authentication = authentication ?: throw PulumiNullFieldException("authentication"),
        endpoint = endpoint ?: throw PulumiNullFieldException("endpoint"),
        fabricPath = fabricPath ?: throw PulumiNullFieldException("fabricPath"),
        guids = guids,
        names = names,
    )
}
