@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.inputs

import com.pulumi.azurenative.iotoperationsmq.inputs.FabricGuidsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Fabric one lake guids.
 * @property lakehouseGuid Fabric one lake house guid.
 * @property workspaceGuid Fabric one lake workspace guid.
 */
public data class FabricGuidsArgs(
    public val lakehouseGuid: Output<String>,
    public val workspaceGuid: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.iotoperationsmq.inputs.FabricGuidsArgs> {
    override fun toJava(): com.pulumi.azurenative.iotoperationsmq.inputs.FabricGuidsArgs =
        com.pulumi.azurenative.iotoperationsmq.inputs.FabricGuidsArgs.builder()
            .lakehouseGuid(lakehouseGuid.applyValue({ args0 -> args0 }))
            .workspaceGuid(workspaceGuid.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FabricGuidsArgs].
 */
@PulumiTagMarker
public class FabricGuidsArgsBuilder internal constructor() {
    private var lakehouseGuid: Output<String>? = null

    private var workspaceGuid: Output<String>? = null

    /**
     * @param value Fabric one lake house guid.
     */
    @JvmName("wacympsmsnrdpxft")
    public suspend fun lakehouseGuid(`value`: Output<String>) {
        this.lakehouseGuid = value
    }

    /**
     * @param value Fabric one lake workspace guid.
     */
    @JvmName("tqhylrineijpbmva")
    public suspend fun workspaceGuid(`value`: Output<String>) {
        this.workspaceGuid = value
    }

    /**
     * @param value Fabric one lake house guid.
     */
    @JvmName("utwhkpsikvadonhd")
    public suspend fun lakehouseGuid(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.lakehouseGuid = mapped
    }

    /**
     * @param value Fabric one lake workspace guid.
     */
    @JvmName("erxqjjlluixbeimn")
    public suspend fun workspaceGuid(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.workspaceGuid = mapped
    }

    internal fun build(): FabricGuidsArgs = FabricGuidsArgs(
        lakehouseGuid = lakehouseGuid ?: throw PulumiNullFieldException("lakehouseGuid"),
        workspaceGuid = workspaceGuid ?: throw PulumiNullFieldException("workspaceGuid"),
    )
}
