@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.inputs

import com.pulumi.azurenative.iotoperationsmq.inputs.GetDataLakeConnectorPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property dataLakeConnectorName Name of MQ dataLakeConnector resource
 * @property mqName Name of MQ resource
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetDataLakeConnectorPlainArgs(
    public val dataLakeConnectorName: String,
    public val mqName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.iotoperationsmq.inputs.GetDataLakeConnectorPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.iotoperationsmq.inputs.GetDataLakeConnectorPlainArgs =
        com.pulumi.azurenative.iotoperationsmq.inputs.GetDataLakeConnectorPlainArgs.builder()
            .dataLakeConnectorName(dataLakeConnectorName.let({ args0 -> args0 }))
            .mqName(mqName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDataLakeConnectorPlainArgs].
 */
@PulumiTagMarker
public class GetDataLakeConnectorPlainArgsBuilder internal constructor() {
    private var dataLakeConnectorName: String? = null

    private var mqName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of MQ dataLakeConnector resource
     */
    @JvmName("lcjitpqyyxheijpq")
    public suspend fun dataLakeConnectorName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.dataLakeConnectorName = mapped
    }

    /**
     * @param value Name of MQ resource
     */
    @JvmName("yakujtmjjqllecru")
    public suspend fun mqName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.mqName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("cpcxplekwxrisxpb")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetDataLakeConnectorPlainArgs = GetDataLakeConnectorPlainArgs(
        dataLakeConnectorName = dataLakeConnectorName ?: throw
            PulumiNullFieldException("dataLakeConnectorName"),
        mqName = mqName ?: throw PulumiNullFieldException("mqName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
