@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.inputs

import com.pulumi.azurenative.iotoperationsmq.inputs.KafkaRemoteBrokerConnectionSpecArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Kafka RemoteBrokerConnectionSpec details
 * @property authentication The remote broker authentication methods.
 * @property endpoint The endpoint of remote broker to connect to.
 * @property tls TLS details for Remote broker Connection.
 */
public data class KafkaRemoteBrokerConnectionSpecArgs(
    public val authentication: Output<KafkaRemoteBrokerAuthenticationPropertiesArgs>,
    public val endpoint: Output<String>,
    public val tls: Output<KafkaRemoteBrokerConnectionTlsArgs>,
) :
    ConvertibleToJava<com.pulumi.azurenative.iotoperationsmq.inputs.KafkaRemoteBrokerConnectionSpecArgs> {
    override fun toJava():
        com.pulumi.azurenative.iotoperationsmq.inputs.KafkaRemoteBrokerConnectionSpecArgs =
        com.pulumi.azurenative.iotoperationsmq.inputs.KafkaRemoteBrokerConnectionSpecArgs.builder()
            .authentication(authentication.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .endpoint(endpoint.applyValue({ args0 -> args0 }))
            .tls(tls.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [KafkaRemoteBrokerConnectionSpecArgs].
 */
@PulumiTagMarker
public class KafkaRemoteBrokerConnectionSpecArgsBuilder internal constructor() {
    private var authentication: Output<KafkaRemoteBrokerAuthenticationPropertiesArgs>? = null

    private var endpoint: Output<String>? = null

    private var tls: Output<KafkaRemoteBrokerConnectionTlsArgs>? = null

    /**
     * @param value The remote broker authentication methods.
     */
    @JvmName("sopvgkeondiqlnis")
    public suspend
    fun authentication(`value`: Output<KafkaRemoteBrokerAuthenticationPropertiesArgs>) {
        this.authentication = value
    }

    /**
     * @param value The endpoint of remote broker to connect to.
     */
    @JvmName("djpawvgmuewcjrdu")
    public suspend fun endpoint(`value`: Output<String>) {
        this.endpoint = value
    }

    /**
     * @param value TLS details for Remote broker Connection.
     */
    @JvmName("xaofuvudwrerhddd")
    public suspend fun tls(`value`: Output<KafkaRemoteBrokerConnectionTlsArgs>) {
        this.tls = value
    }

    /**
     * @param value The remote broker authentication methods.
     */
    @JvmName("tlfvmpfnckckhibg")
    public suspend fun authentication(`value`: KafkaRemoteBrokerAuthenticationPropertiesArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authentication = mapped
    }

    /**
     * @param argument The remote broker authentication methods.
     */
    @JvmName("jffitktrodqnvgtb")
    public suspend
    fun authentication(argument: suspend KafkaRemoteBrokerAuthenticationPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = KafkaRemoteBrokerAuthenticationPropertiesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.authentication = mapped
    }

    /**
     * @param value The endpoint of remote broker to connect to.
     */
    @JvmName("mygyxxfbqhwsehcm")
    public suspend fun endpoint(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.endpoint = mapped
    }

    /**
     * @param value TLS details for Remote broker Connection.
     */
    @JvmName("pnesogiuieqqwwcv")
    public suspend fun tls(`value`: KafkaRemoteBrokerConnectionTlsArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tls = mapped
    }

    /**
     * @param argument TLS details for Remote broker Connection.
     */
    @JvmName("uryorrmyybingwui")
    public suspend fun tls(argument: suspend KafkaRemoteBrokerConnectionTlsArgsBuilder.() -> Unit) {
        val toBeMapped = KafkaRemoteBrokerConnectionTlsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.tls = mapped
    }

    internal fun build(): KafkaRemoteBrokerConnectionSpecArgs = KafkaRemoteBrokerConnectionSpecArgs(
        authentication = authentication ?: throw PulumiNullFieldException("authentication"),
        endpoint = endpoint ?: throw PulumiNullFieldException("endpoint"),
        tls = tls ?: throw PulumiNullFieldException("tls"),
    )
}
