@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.inputs

import com.pulumi.azurenative.iotoperationsmq.inputs.KafkaRemoteBrokerConnectionTlsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Kafka RemoteBrokerConnection TLS details
 * @property tlsEnabled Tls Enabled on Remote Broker Connection.
 * @property trustedCaCertificateConfigMap Trusted CA certificate name for Remote Broker.
 */
public data class KafkaRemoteBrokerConnectionTlsArgs(
    public val tlsEnabled: Output<Boolean>,
    public val trustedCaCertificateConfigMap: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.iotoperationsmq.inputs.KafkaRemoteBrokerConnectionTlsArgs> {
    override fun toJava():
        com.pulumi.azurenative.iotoperationsmq.inputs.KafkaRemoteBrokerConnectionTlsArgs =
        com.pulumi.azurenative.iotoperationsmq.inputs.KafkaRemoteBrokerConnectionTlsArgs.builder()
            .tlsEnabled(tlsEnabled.applyValue({ args0 -> args0 }))
            .trustedCaCertificateConfigMap(
                trustedCaCertificateConfigMap?.applyValue({ args0 ->
                    args0
                }),
            ).build()
}

/**
 * Builder for [KafkaRemoteBrokerConnectionTlsArgs].
 */
@PulumiTagMarker
public class KafkaRemoteBrokerConnectionTlsArgsBuilder internal constructor() {
    private var tlsEnabled: Output<Boolean>? = null

    private var trustedCaCertificateConfigMap: Output<String>? = null

    /**
     * @param value Tls Enabled on Remote Broker Connection.
     */
    @JvmName("pkrabeqmmllovqmc")
    public suspend fun tlsEnabled(`value`: Output<Boolean>) {
        this.tlsEnabled = value
    }

    /**
     * @param value Trusted CA certificate name for Remote Broker.
     */
    @JvmName("eritpfsvawlagnxr")
    public suspend fun trustedCaCertificateConfigMap(`value`: Output<String>) {
        this.trustedCaCertificateConfigMap = value
    }

    /**
     * @param value Tls Enabled on Remote Broker Connection.
     */
    @JvmName("rgrcljfhhwuqhket")
    public suspend fun tlsEnabled(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tlsEnabled = mapped
    }

    /**
     * @param value Trusted CA certificate name for Remote Broker.
     */
    @JvmName("djoyfoyuivwnhklp")
    public suspend fun trustedCaCertificateConfigMap(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trustedCaCertificateConfigMap = mapped
    }

    internal fun build(): KafkaRemoteBrokerConnectionTlsArgs = KafkaRemoteBrokerConnectionTlsArgs(
        tlsEnabled = tlsEnabled ?: throw PulumiNullFieldException("tlsEnabled"),
        trustedCaCertificateConfigMap = trustedCaCertificateConfigMap,
    )
}
