@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.inputs

import com.pulumi.azurenative.iotoperationsmq.inputs.KafkaToMqttRoutesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Kafka to Mqtt route properties
 * @property consumerGroupId The consumer group id to use.
 * @property kafkaTopic The kafka topic to pull from.
 * @property mqttTopic The mqtt topic to publish to.
 * @property name The name of the route.
 * @property qos The qos to use for mqtt.
 */
public data class KafkaToMqttRoutesArgs(
    public val consumerGroupId: Output<String>? = null,
    public val kafkaTopic: Output<String>,
    public val mqttTopic: Output<String>,
    public val name: Output<String>,
    public val qos: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.iotoperationsmq.inputs.KafkaToMqttRoutesArgs> {
    override fun toJava(): com.pulumi.azurenative.iotoperationsmq.inputs.KafkaToMqttRoutesArgs =
        com.pulumi.azurenative.iotoperationsmq.inputs.KafkaToMqttRoutesArgs.builder()
            .consumerGroupId(consumerGroupId?.applyValue({ args0 -> args0 }))
            .kafkaTopic(kafkaTopic.applyValue({ args0 -> args0 }))
            .mqttTopic(mqttTopic.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 }))
            .qos(qos?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [KafkaToMqttRoutesArgs].
 */
@PulumiTagMarker
public class KafkaToMqttRoutesArgsBuilder internal constructor() {
    private var consumerGroupId: Output<String>? = null

    private var kafkaTopic: Output<String>? = null

    private var mqttTopic: Output<String>? = null

    private var name: Output<String>? = null

    private var qos: Output<Int>? = null

    /**
     * @param value The consumer group id to use.
     */
    @JvmName("nbxhfutphvgvsdsw")
    public suspend fun consumerGroupId(`value`: Output<String>) {
        this.consumerGroupId = value
    }

    /**
     * @param value The kafka topic to pull from.
     */
    @JvmName("fcqiwxajxpukhsog")
    public suspend fun kafkaTopic(`value`: Output<String>) {
        this.kafkaTopic = value
    }

    /**
     * @param value The mqtt topic to publish to.
     */
    @JvmName("wepmmniqxcdvvfod")
    public suspend fun mqttTopic(`value`: Output<String>) {
        this.mqttTopic = value
    }

    /**
     * @param value The name of the route.
     */
    @JvmName("bmrlctnpmongqbwq")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The qos to use for mqtt.
     */
    @JvmName("ecitpikvakswdorb")
    public suspend fun qos(`value`: Output<Int>) {
        this.qos = value
    }

    /**
     * @param value The consumer group id to use.
     */
    @JvmName("iekirywisddhjqsi")
    public suspend fun consumerGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.consumerGroupId = mapped
    }

    /**
     * @param value The kafka topic to pull from.
     */
    @JvmName("lkuobgcwsvkiaktx")
    public suspend fun kafkaTopic(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kafkaTopic = mapped
    }

    /**
     * @param value The mqtt topic to publish to.
     */
    @JvmName("uoqmfktpehrfohpl")
    public suspend fun mqttTopic(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mqttTopic = mapped
    }

    /**
     * @param value The name of the route.
     */
    @JvmName("pitiydnxatjftpla")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The qos to use for mqtt.
     */
    @JvmName("hwktfyqredfmgcfa")
    public suspend fun qos(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.qos = mapped
    }

    internal fun build(): KafkaToMqttRoutesArgs = KafkaToMqttRoutesArgs(
        consumerGroupId = consumerGroupId,
        kafkaTopic = kafkaTopic ?: throw PulumiNullFieldException("kafkaTopic"),
        mqttTopic = mqttTopic ?: throw PulumiNullFieldException("mqttTopic"),
        name = name ?: throw PulumiNullFieldException("name"),
        qos = qos,
    )
}
