@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.inputs

import com.pulumi.azurenative.iotoperationsmq.inputs.KafkaTokenKeyVaultPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Kafka Token KeyVault properties.
 * @property username Username to connect with.
 * @property vault KeyVault properties.
 * @property vaultSecret KeyVault secret details.
 */
public data class KafkaTokenKeyVaultPropertiesArgs(
    public val username: Output<String>? = null,
    public val vault: Output<KeyVaultConnectionPropertiesArgs>,
    public val vaultSecret: Output<KeyVaultSecretObjectArgs>,
) :
    ConvertibleToJava<com.pulumi.azurenative.iotoperationsmq.inputs.KafkaTokenKeyVaultPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.iotoperationsmq.inputs.KafkaTokenKeyVaultPropertiesArgs =
        com.pulumi.azurenative.iotoperationsmq.inputs.KafkaTokenKeyVaultPropertiesArgs.builder()
            .username(username?.applyValue({ args0 -> args0 }))
            .vault(vault.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .vaultSecret(vaultSecret.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [KafkaTokenKeyVaultPropertiesArgs].
 */
@PulumiTagMarker
public class KafkaTokenKeyVaultPropertiesArgsBuilder internal constructor() {
    private var username: Output<String>? = null

    private var vault: Output<KeyVaultConnectionPropertiesArgs>? = null

    private var vaultSecret: Output<KeyVaultSecretObjectArgs>? = null

    /**
     * @param value Username to connect with.
     */
    @JvmName("fmjuqudaxtteofls")
    public suspend fun username(`value`: Output<String>) {
        this.username = value
    }

    /**
     * @param value KeyVault properties.
     */
    @JvmName("ctxuimbnaiachnmy")
    public suspend fun vault(`value`: Output<KeyVaultConnectionPropertiesArgs>) {
        this.vault = value
    }

    /**
     * @param value KeyVault secret details.
     */
    @JvmName("uxbyprrrjnrpnomr")
    public suspend fun vaultSecret(`value`: Output<KeyVaultSecretObjectArgs>) {
        this.vaultSecret = value
    }

    /**
     * @param value Username to connect with.
     */
    @JvmName("juespqgjrajjymqq")
    public suspend fun username(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.username = mapped
    }

    /**
     * @param value KeyVault properties.
     */
    @JvmName("vjmprjyppubjbgch")
    public suspend fun vault(`value`: KeyVaultConnectionPropertiesArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vault = mapped
    }

    /**
     * @param argument KeyVault properties.
     */
    @JvmName("tmasuitlxkvkxvba")
    public suspend fun vault(argument: suspend KeyVaultConnectionPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = KeyVaultConnectionPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.vault = mapped
    }

    /**
     * @param value KeyVault secret details.
     */
    @JvmName("hgjrseywmngvhspa")
    public suspend fun vaultSecret(`value`: KeyVaultSecretObjectArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vaultSecret = mapped
    }

    /**
     * @param argument KeyVault secret details.
     */
    @JvmName("xileylgesoutxayy")
    public suspend fun vaultSecret(argument: suspend KeyVaultSecretObjectArgsBuilder.() -> Unit) {
        val toBeMapped = KeyVaultSecretObjectArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.vaultSecret = mapped
    }

    internal fun build(): KafkaTokenKeyVaultPropertiesArgs = KafkaTokenKeyVaultPropertiesArgs(
        username = username,
        vault = vault ?: throw PulumiNullFieldException("vault"),
        vaultSecret = vaultSecret ?: throw PulumiNullFieldException("vaultSecret"),
    )
}
