@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.inputs

import com.pulumi.azurenative.iotoperationsmq.inputs.LocalBrokerConnectionSpecArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Mqtt Local Broker ConnectionSpec details
 * @property authentication The authentication methods for LocalBroker connection. NOTE - Enum only one method at a time is supported.
 * @property endpoint The endpoint of local broker to connect to.
 * @property tls TLS details for Local broker Connection.
 */
public data class LocalBrokerConnectionSpecArgs(
    public val authentication: Output<LocalBrokerAuthenticationMethodsArgs>? = null,
    public val endpoint: Output<String>? = null,
    public val tls: Output<LocalBrokerConnectionTlsArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.iotoperationsmq.inputs.LocalBrokerConnectionSpecArgs> {
    override fun toJava(): com.pulumi.azurenative.iotoperationsmq.inputs.LocalBrokerConnectionSpecArgs =
        com.pulumi.azurenative.iotoperationsmq.inputs.LocalBrokerConnectionSpecArgs.builder()
            .authentication(authentication?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .endpoint(endpoint?.applyValue({ args0 -> args0 }))
            .tls(tls?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [LocalBrokerConnectionSpecArgs].
 */
@PulumiTagMarker
public class LocalBrokerConnectionSpecArgsBuilder internal constructor() {
    private var authentication: Output<LocalBrokerAuthenticationMethodsArgs>? = null

    private var endpoint: Output<String>? = null

    private var tls: Output<LocalBrokerConnectionTlsArgs>? = null

    /**
     * @param value The authentication methods for LocalBroker connection. NOTE - Enum only one method at a time is supported.
     */
    @JvmName("pefmyqbiauakkyop")
    public suspend fun authentication(`value`: Output<LocalBrokerAuthenticationMethodsArgs>) {
        this.authentication = value
    }

    /**
     * @param value The endpoint of local broker to connect to.
     */
    @JvmName("iiyncqcwqkpaqntd")
    public suspend fun endpoint(`value`: Output<String>) {
        this.endpoint = value
    }

    /**
     * @param value TLS details for Local broker Connection.
     */
    @JvmName("fdhlroyfqwhayqgb")
    public suspend fun tls(`value`: Output<LocalBrokerConnectionTlsArgs>) {
        this.tls = value
    }

    /**
     * @param value The authentication methods for LocalBroker connection. NOTE - Enum only one method at a time is supported.
     */
    @JvmName("sdhwyaysngumkgyg")
    public suspend fun authentication(`value`: LocalBrokerAuthenticationMethodsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authentication = mapped
    }

    /**
     * @param argument The authentication methods for LocalBroker connection. NOTE - Enum only one method at a time is supported.
     */
    @JvmName("blbrareebplkiaup")
    public suspend
    fun authentication(argument: suspend LocalBrokerAuthenticationMethodsArgsBuilder.() -> Unit) {
        val toBeMapped = LocalBrokerAuthenticationMethodsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.authentication = mapped
    }

    /**
     * @param value The endpoint of local broker to connect to.
     */
    @JvmName("lqnlfycaqtdrhtgd")
    public suspend fun endpoint(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpoint = mapped
    }

    /**
     * @param value TLS details for Local broker Connection.
     */
    @JvmName("txgrktbyecchuowl")
    public suspend fun tls(`value`: LocalBrokerConnectionTlsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tls = mapped
    }

    /**
     * @param argument TLS details for Local broker Connection.
     */
    @JvmName("lwloufikmbcqrojn")
    public suspend fun tls(argument: suspend LocalBrokerConnectionTlsArgsBuilder.() -> Unit) {
        val toBeMapped = LocalBrokerConnectionTlsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.tls = mapped
    }

    internal fun build(): LocalBrokerConnectionSpecArgs = LocalBrokerConnectionSpecArgs(
        authentication = authentication,
        endpoint = endpoint,
        tls = tls,
    )
}
