@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.inputs

import com.pulumi.azurenative.iotoperationsmq.inputs.NodeTolerationsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Defines the Node Tolerations details
 * @property effect Toleration effect.
 * @property key Toleration key.
 * @property operator Toleration operator like 'Exists', 'Equal' etc.
 * @property value Toleration Value.
 */
public data class NodeTolerationsArgs(
    public val effect: Output<String>,
    public val key: Output<String>,
    public val `operator`: Output<String>,
    public val `value`: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.iotoperationsmq.inputs.NodeTolerationsArgs> {
    override fun toJava(): com.pulumi.azurenative.iotoperationsmq.inputs.NodeTolerationsArgs =
        com.pulumi.azurenative.iotoperationsmq.inputs.NodeTolerationsArgs.builder()
            .effect(effect.applyValue({ args0 -> args0 }))
            .key(key.applyValue({ args0 -> args0 }))
            .`operator`(`operator`.applyValue({ args0 -> args0 }))
            .`value`(`value`.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NodeTolerationsArgs].
 */
@PulumiTagMarker
public class NodeTolerationsArgsBuilder internal constructor() {
    private var effect: Output<String>? = null

    private var key: Output<String>? = null

    private var `operator`: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value Toleration effect.
     */
    @JvmName("wllwoxpyhqplbequ")
    public suspend fun effect(`value`: Output<String>) {
        this.effect = value
    }

    /**
     * @param value Toleration key.
     */
    @JvmName("atrlvqpxdtdchbmd")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value Toleration operator like 'Exists', 'Equal' etc.
     */
    @JvmName("iacynjfunramxlhq")
    public suspend fun `operator`(`value`: Output<String>) {
        this.`operator` = value
    }

    /**
     * @param value Toleration Value.
     */
    @JvmName("nkvpddpdtswirsbg")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value Toleration effect.
     */
    @JvmName("vmghwlfjtapotyvm")
    public suspend fun effect(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.effect = mapped
    }

    /**
     * @param value Toleration key.
     */
    @JvmName("jmtccsteawsqhxgk")
    public suspend fun key(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.key = mapped
    }

    /**
     * @param value Toleration operator like 'Exists', 'Equal' etc.
     */
    @JvmName("pucrsmawtmgkmelv")
    public suspend fun `operator`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`operator` = mapped
    }

    /**
     * @param value Toleration Value.
     */
    @JvmName("jcmgewvbcnedogeq")
    public suspend fun `value`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): NodeTolerationsArgs = NodeTolerationsArgs(
        effect = effect ?: throw PulumiNullFieldException("effect"),
        key = key ?: throw PulumiNullFieldException("key"),
        `operator` = `operator` ?: throw PulumiNullFieldException("operator"),
        `value` = `value` ?: throw PulumiNullFieldException("value"),
    )
}
