@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.inputs

import com.pulumi.azurenative.iotoperationsmq.inputs.PrincipalDefinitionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * PrincipalDefinition properties of Basic Rule
 * @property attributes A list of key-value pairs that match the attributes of the clients. The attributes are case-sensitive and must match the attributes provided by the clients during authentication.
 * @property clientids A list of client IDs that match the clients. The client IDs are case-sensitive and must match the client IDs provided by the clients during connection.
 * @property usernames A list of usernames that match the clients. The usernames are case-sensitive and must match the usernames provided by the clients during authentication.
 */
public data class PrincipalDefinitionArgs(
    public val attributes: Output<List<Map<String, String>>>? = null,
    public val clientids: Output<List<String>>? = null,
    public val usernames: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.iotoperationsmq.inputs.PrincipalDefinitionArgs> {
    override fun toJava(): com.pulumi.azurenative.iotoperationsmq.inputs.PrincipalDefinitionArgs =
        com.pulumi.azurenative.iotoperationsmq.inputs.PrincipalDefinitionArgs.builder()
            .attributes(
                attributes?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.map({ args0 ->
                            args0.key.to(args0.value)
                        }).toMap()
                    })
                }),
            )
            .clientids(clientids?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .usernames(usernames?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [PrincipalDefinitionArgs].
 */
@PulumiTagMarker
public class PrincipalDefinitionArgsBuilder internal constructor() {
    private var attributes: Output<List<Map<String, String>>>? = null

    private var clientids: Output<List<String>>? = null

    private var usernames: Output<List<String>>? = null

    /**
     * @param value A list of key-value pairs that match the attributes of the clients. The attributes are case-sensitive and must match the attributes provided by the clients during authentication.
     */
    @JvmName("gjxbaqwgrlkiaedo")
    public suspend fun attributes(`value`: Output<List<Map<String, String>>>) {
        this.attributes = value
    }

    @JvmName("wapnghhklnuphrdv")
    public suspend fun attributes(vararg values: Output<Map<String, String>>) {
        this.attributes = Output.all(values.asList())
    }

    /**
     * @param values A list of key-value pairs that match the attributes of the clients. The attributes are case-sensitive and must match the attributes provided by the clients during authentication.
     */
    @JvmName("xrqfowkwkgglwbgt")
    public suspend fun attributes(values: List<Output<Map<String, String>>>) {
        this.attributes = Output.all(values)
    }

    /**
     * @param value A list of client IDs that match the clients. The client IDs are case-sensitive and must match the client IDs provided by the clients during connection.
     */
    @JvmName("jnlsltauuklvlkyu")
    public suspend fun clientids(`value`: Output<List<String>>) {
        this.clientids = value
    }

    @JvmName("uvhanvfffumtkrmw")
    public suspend fun clientids(vararg values: Output<String>) {
        this.clientids = Output.all(values.asList())
    }

    /**
     * @param values A list of client IDs that match the clients. The client IDs are case-sensitive and must match the client IDs provided by the clients during connection.
     */
    @JvmName("ujmdvxucmlqjpuiq")
    public suspend fun clientids(values: List<Output<String>>) {
        this.clientids = Output.all(values)
    }

    /**
     * @param value A list of usernames that match the clients. The usernames are case-sensitive and must match the usernames provided by the clients during authentication.
     */
    @JvmName("kuajbiipapdqavxq")
    public suspend fun usernames(`value`: Output<List<String>>) {
        this.usernames = value
    }

    @JvmName("ewirsumgbcbhgqli")
    public suspend fun usernames(vararg values: Output<String>) {
        this.usernames = Output.all(values.asList())
    }

    /**
     * @param values A list of usernames that match the clients. The usernames are case-sensitive and must match the usernames provided by the clients during authentication.
     */
    @JvmName("whfolbnntshxlxfa")
    public suspend fun usernames(values: List<Output<String>>) {
        this.usernames = Output.all(values)
    }

    /**
     * @param value A list of key-value pairs that match the attributes of the clients. The attributes are case-sensitive and must match the attributes provided by the clients during authentication.
     */
    @JvmName("vmgqexrucijtpucu")
    public suspend fun attributes(`value`: List<Map<String, String>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.attributes = mapped
    }

    /**
     * @param values A list of key-value pairs that match the attributes of the clients. The attributes are case-sensitive and must match the attributes provided by the clients during authentication.
     */
    @JvmName("ssrrangwhpujxruw")
    public suspend fun attributes(vararg values: Map<String, String>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.attributes = mapped
    }

    /**
     * @param value A list of client IDs that match the clients. The client IDs are case-sensitive and must match the client IDs provided by the clients during connection.
     */
    @JvmName("atqjlbtytdxiwivo")
    public suspend fun clientids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientids = mapped
    }

    /**
     * @param values A list of client IDs that match the clients. The client IDs are case-sensitive and must match the client IDs provided by the clients during connection.
     */
    @JvmName("jrlsmjstnwlkwfaw")
    public suspend fun clientids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clientids = mapped
    }

    /**
     * @param value A list of usernames that match the clients. The usernames are case-sensitive and must match the usernames provided by the clients during authentication.
     */
    @JvmName("kyklesybugugkgub")
    public suspend fun usernames(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.usernames = mapped
    }

    /**
     * @param values A list of usernames that match the clients. The usernames are case-sensitive and must match the usernames provided by the clients during authentication.
     */
    @JvmName("ffhraabsdwubnuhf")
    public suspend fun usernames(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.usernames = mapped
    }

    internal fun build(): PrincipalDefinitionArgs = PrincipalDefinitionArgs(
        attributes = attributes,
        clientids = clientids,
        usernames = usernames,
    )
}
