@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.inputs

import com.pulumi.azurenative.iotoperationsmq.inputs.TlsCertMethodArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Collection of different TLS types, NOTE- Enum at a time only one of them needs to be supported
 * @property automatic Option 1 - Automatic TLS server certificate management with cert-manager.
 * @property keyVault Option 3 - TLS server certificate retrieved from Key Vault..
 * @property manual Option 2 - Manual TLS server certificate management through a defined secret.
 */
public data class TlsCertMethodArgs(
    public val automatic: Output<AutomaticCertMethodArgs>? = null,
    public val keyVault: Output<KeyVaultCertificatePropertiesArgs>? = null,
    public val manual: Output<ManualCertMethodArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.iotoperationsmq.inputs.TlsCertMethodArgs> {
    override fun toJava(): com.pulumi.azurenative.iotoperationsmq.inputs.TlsCertMethodArgs =
        com.pulumi.azurenative.iotoperationsmq.inputs.TlsCertMethodArgs.builder()
            .automatic(automatic?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .keyVault(keyVault?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .manual(manual?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [TlsCertMethodArgs].
 */
@PulumiTagMarker
public class TlsCertMethodArgsBuilder internal constructor() {
    private var automatic: Output<AutomaticCertMethodArgs>? = null

    private var keyVault: Output<KeyVaultCertificatePropertiesArgs>? = null

    private var manual: Output<ManualCertMethodArgs>? = null

    /**
     * @param value Option 1 - Automatic TLS server certificate management with cert-manager.
     */
    @JvmName("smoshxmcocamaejp")
    public suspend fun automatic(`value`: Output<AutomaticCertMethodArgs>) {
        this.automatic = value
    }

    /**
     * @param value Option 3 - TLS server certificate retrieved from Key Vault..
     */
    @JvmName("oavnsdlbxmygxgnb")
    public suspend fun keyVault(`value`: Output<KeyVaultCertificatePropertiesArgs>) {
        this.keyVault = value
    }

    /**
     * @param value Option 2 - Manual TLS server certificate management through a defined secret.
     */
    @JvmName("mhonbuftcjutahnw")
    public suspend fun manual(`value`: Output<ManualCertMethodArgs>) {
        this.manual = value
    }

    /**
     * @param value Option 1 - Automatic TLS server certificate management with cert-manager.
     */
    @JvmName("ffxjgeyahfpkwhru")
    public suspend fun automatic(`value`: AutomaticCertMethodArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.automatic = mapped
    }

    /**
     * @param argument Option 1 - Automatic TLS server certificate management with cert-manager.
     */
    @JvmName("aovbuinewfqxnsrt")
    public suspend fun automatic(argument: suspend AutomaticCertMethodArgsBuilder.() -> Unit) {
        val toBeMapped = AutomaticCertMethodArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.automatic = mapped
    }

    /**
     * @param value Option 3 - TLS server certificate retrieved from Key Vault..
     */
    @JvmName("etvdmxejqjkdwkam")
    public suspend fun keyVault(`value`: KeyVaultCertificatePropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyVault = mapped
    }

    /**
     * @param argument Option 3 - TLS server certificate retrieved from Key Vault..
     */
    @JvmName("fpqwyvyuhtsknuul")
    public suspend
    fun keyVault(argument: suspend KeyVaultCertificatePropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = KeyVaultCertificatePropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.keyVault = mapped
    }

    /**
     * @param value Option 2 - Manual TLS server certificate management through a defined secret.
     */
    @JvmName("vyuonpveyiuknkxb")
    public suspend fun manual(`value`: ManualCertMethodArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.manual = mapped
    }

    /**
     * @param argument Option 2 - Manual TLS server certificate management through a defined secret.
     */
    @JvmName("tvxtometwqbwbrsk")
    public suspend fun manual(argument: suspend ManualCertMethodArgsBuilder.() -> Unit) {
        val toBeMapped = ManualCertMethodArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.manual = mapped
    }

    internal fun build(): TlsCertMethodArgs = TlsCertMethodArgs(
        automatic = automatic,
        keyVault = keyVault,
        manual = manual,
    )
}
