@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.inputs

import com.pulumi.azurenative.iotoperationsmq.inputs.VolumeClaimSpecArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * VolumeClaimSpec properties
 * @property accessModes AccessModes contains the desired access modes the volume should have. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#access-modes-1
 * @property dataSource This field can be used to specify either: * An existing VolumeSnapshot object (snapshot.storage.k8s.io/VolumeSnapshot) * An existing PVC (PersistentVolumeClaim) If the provisioner or an external controller can support the specified data source, it will create a new volume based on the contents of the specified data source. If the AnyVolumeDataSource feature gate is enabled, this field will always have the same contents as the DataSourceRef field.
 * @property dataSourceRef Specifies the object from which to populate the volume with data, if a non-empty volume is desired. This may be any local object from a non-empty API group (non core object) or a PersistentVolumeClaim object. When this field is specified, volume binding will only succeed if the type of the specified object matches some installed volume populator or dynamic provisioner. This field will replace the functionality of the DataSource field and as such if both fields are non-empty, they must have the same value. For backwards compatibility, both fields (DataSource and DataSourceRef) will be set to the same value automatically if one of them is empty and the other is non-empty. There are two important differences between DataSource and DataSourceRef: * While DataSource only allows two specific types of objects, DataSourceRef allows any non-core object, as well as PersistentVolumeClaim objects. * While DataSource ignores disallowed values (dropping them), DataSourceRef preserves all values, and generates an error if a disallowed value is specified. (Alpha) Using this field requires the AnyVolumeDataSource feature gate to be enabled.
 * @property resources Resources represents the minimum resources the volume should have. If RecoverVolumeExpansionFailure feature is enabled users are allowed to specify resource requirements that are lower than previous value but must still be higher than capacity recorded in the status field of the claim. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#resources
 * @property selector A label query over volumes to consider for binding.
 * @property storageClassName Name of the StorageClass required by the claim. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#class-1
 * @property volumeMode volumeMode defines what type of volume is required by the claim. Value of Filesystem is implied when not included in claim spec. This is a beta feature.
 * @property volumeName VolumeName is the binding reference to the PersistentVolume backing this claim.
 */
public data class VolumeClaimSpecArgs(
    public val accessModes: Output<List<String>>? = null,
    public val dataSource: Output<VolumeClaimDataSourceArgs>? = null,
    public val dataSourceRef: Output<VolumeClaimDataSourceRefArgs>? = null,
    public val resources: Output<VolumeClaimResourceRequirementsArgs>? = null,
    public val selector: Output<VolumeClaimSpecSelectorArgs>? = null,
    public val storageClassName: Output<String>? = null,
    public val volumeMode: Output<String>? = null,
    public val volumeName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.iotoperationsmq.inputs.VolumeClaimSpecArgs> {
    override fun toJava(): com.pulumi.azurenative.iotoperationsmq.inputs.VolumeClaimSpecArgs =
        com.pulumi.azurenative.iotoperationsmq.inputs.VolumeClaimSpecArgs.builder()
            .accessModes(accessModes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .dataSource(dataSource?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .dataSourceRef(dataSourceRef?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resources(resources?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .selector(selector?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .storageClassName(storageClassName?.applyValue({ args0 -> args0 }))
            .volumeMode(volumeMode?.applyValue({ args0 -> args0 }))
            .volumeName(volumeName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VolumeClaimSpecArgs].
 */
@PulumiTagMarker
public class VolumeClaimSpecArgsBuilder internal constructor() {
    private var accessModes: Output<List<String>>? = null

    private var dataSource: Output<VolumeClaimDataSourceArgs>? = null

    private var dataSourceRef: Output<VolumeClaimDataSourceRefArgs>? = null

    private var resources: Output<VolumeClaimResourceRequirementsArgs>? = null

    private var selector: Output<VolumeClaimSpecSelectorArgs>? = null

    private var storageClassName: Output<String>? = null

    private var volumeMode: Output<String>? = null

    private var volumeName: Output<String>? = null

    /**
     * @param value AccessModes contains the desired access modes the volume should have. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#access-modes-1
     */
    @JvmName("quhslvyypnhmimai")
    public suspend fun accessModes(`value`: Output<List<String>>) {
        this.accessModes = value
    }

    @JvmName("pymtdlcyntsoybgl")
    public suspend fun accessModes(vararg values: Output<String>) {
        this.accessModes = Output.all(values.asList())
    }

    /**
     * @param values AccessModes contains the desired access modes the volume should have. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#access-modes-1
     */
    @JvmName("jioaphtxkvusqwds")
    public suspend fun accessModes(values: List<Output<String>>) {
        this.accessModes = Output.all(values)
    }

    /**
     * @param value This field can be used to specify either: * An existing VolumeSnapshot object (snapshot.storage.k8s.io/VolumeSnapshot) * An existing PVC (PersistentVolumeClaim) If the provisioner or an external controller can support the specified data source, it will create a new volume based on the contents of the specified data source. If the AnyVolumeDataSource feature gate is enabled, this field will always have the same contents as the DataSourceRef field.
     */
    @JvmName("crhnvmhiblrjuhfm")
    public suspend fun dataSource(`value`: Output<VolumeClaimDataSourceArgs>) {
        this.dataSource = value
    }

    /**
     * @param value Specifies the object from which to populate the volume with data, if a non-empty volume is desired. This may be any local object from a non-empty API group (non core object) or a PersistentVolumeClaim object. When this field is specified, volume binding will only succeed if the type of the specified object matches some installed volume populator or dynamic provisioner. This field will replace the functionality of the DataSource field and as such if both fields are non-empty, they must have the same value. For backwards compatibility, both fields (DataSource and DataSourceRef) will be set to the same value automatically if one of them is empty and the other is non-empty. There are two important differences between DataSource and DataSourceRef: * While DataSource only allows two specific types of objects, DataSourceRef allows any non-core object, as well as PersistentVolumeClaim objects. * While DataSource ignores disallowed values (dropping them), DataSourceRef preserves all values, and generates an error if a disallowed value is specified. (Alpha) Using this field requires the AnyVolumeDataSource feature gate to be enabled.
     */
    @JvmName("ofpccmryqpmhhrur")
    public suspend fun dataSourceRef(`value`: Output<VolumeClaimDataSourceRefArgs>) {
        this.dataSourceRef = value
    }

    /**
     * @param value Resources represents the minimum resources the volume should have. If RecoverVolumeExpansionFailure feature is enabled users are allowed to specify resource requirements that are lower than previous value but must still be higher than capacity recorded in the status field of the claim. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#resources
     */
    @JvmName("gunqevbppthqqoes")
    public suspend fun resources(`value`: Output<VolumeClaimResourceRequirementsArgs>) {
        this.resources = value
    }

    /**
     * @param value A label query over volumes to consider for binding.
     */
    @JvmName("mopdtkehbwfgmsbq")
    public suspend fun selector(`value`: Output<VolumeClaimSpecSelectorArgs>) {
        this.selector = value
    }

    /**
     * @param value Name of the StorageClass required by the claim. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#class-1
     */
    @JvmName("nrdtmjsibtaftlbb")
    public suspend fun storageClassName(`value`: Output<String>) {
        this.storageClassName = value
    }

    /**
     * @param value volumeMode defines what type of volume is required by the claim. Value of Filesystem is implied when not included in claim spec. This is a beta feature.
     */
    @JvmName("sbuaqxgnxtehtomh")
    public suspend fun volumeMode(`value`: Output<String>) {
        this.volumeMode = value
    }

    /**
     * @param value VolumeName is the binding reference to the PersistentVolume backing this claim.
     */
    @JvmName("olamahrqkybwpehv")
    public suspend fun volumeName(`value`: Output<String>) {
        this.volumeName = value
    }

    /**
     * @param value AccessModes contains the desired access modes the volume should have. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#access-modes-1
     */
    @JvmName("xrqmvetqmmtyxshy")
    public suspend fun accessModes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessModes = mapped
    }

    /**
     * @param values AccessModes contains the desired access modes the volume should have. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#access-modes-1
     */
    @JvmName("ootwbimmvjlhmnvv")
    public suspend fun accessModes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.accessModes = mapped
    }

    /**
     * @param value This field can be used to specify either: * An existing VolumeSnapshot object (snapshot.storage.k8s.io/VolumeSnapshot) * An existing PVC (PersistentVolumeClaim) If the provisioner or an external controller can support the specified data source, it will create a new volume based on the contents of the specified data source. If the AnyVolumeDataSource feature gate is enabled, this field will always have the same contents as the DataSourceRef field.
     */
    @JvmName("bgenwrwuyvvmeyuw")
    public suspend fun dataSource(`value`: VolumeClaimDataSourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataSource = mapped
    }

    /**
     * @param argument This field can be used to specify either: * An existing VolumeSnapshot object (snapshot.storage.k8s.io/VolumeSnapshot) * An existing PVC (PersistentVolumeClaim) If the provisioner or an external controller can support the specified data source, it will create a new volume based on the contents of the specified data source. If the AnyVolumeDataSource feature gate is enabled, this field will always have the same contents as the DataSourceRef field.
     */
    @JvmName("ugwcrqwnqydyflhq")
    public suspend fun dataSource(argument: suspend VolumeClaimDataSourceArgsBuilder.() -> Unit) {
        val toBeMapped = VolumeClaimDataSourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.dataSource = mapped
    }

    /**
     * @param value Specifies the object from which to populate the volume with data, if a non-empty volume is desired. This may be any local object from a non-empty API group (non core object) or a PersistentVolumeClaim object. When this field is specified, volume binding will only succeed if the type of the specified object matches some installed volume populator or dynamic provisioner. This field will replace the functionality of the DataSource field and as such if both fields are non-empty, they must have the same value. For backwards compatibility, both fields (DataSource and DataSourceRef) will be set to the same value automatically if one of them is empty and the other is non-empty. There are two important differences between DataSource and DataSourceRef: * While DataSource only allows two specific types of objects, DataSourceRef allows any non-core object, as well as PersistentVolumeClaim objects. * While DataSource ignores disallowed values (dropping them), DataSourceRef preserves all values, and generates an error if a disallowed value is specified. (Alpha) Using this field requires the AnyVolumeDataSource feature gate to be enabled.
     */
    @JvmName("kuhmdhyjvpynwewv")
    public suspend fun dataSourceRef(`value`: VolumeClaimDataSourceRefArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataSourceRef = mapped
    }

    /**
     * @param argument Specifies the object from which to populate the volume with data, if a non-empty volume is desired. This may be any local object from a non-empty API group (non core object) or a PersistentVolumeClaim object. When this field is specified, volume binding will only succeed if the type of the specified object matches some installed volume populator or dynamic provisioner. This field will replace the functionality of the DataSource field and as such if both fields are non-empty, they must have the same value. For backwards compatibility, both fields (DataSource and DataSourceRef) will be set to the same value automatically if one of them is empty and the other is non-empty. There are two important differences between DataSource and DataSourceRef: * While DataSource only allows two specific types of objects, DataSourceRef allows any non-core object, as well as PersistentVolumeClaim objects. * While DataSource ignores disallowed values (dropping them), DataSourceRef preserves all values, and generates an error if a disallowed value is specified. (Alpha) Using this field requires the AnyVolumeDataSource feature gate to be enabled.
     */
    @JvmName("ihfietcnhokgbjxq")
    public suspend
    fun dataSourceRef(argument: suspend VolumeClaimDataSourceRefArgsBuilder.() -> Unit) {
        val toBeMapped = VolumeClaimDataSourceRefArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.dataSourceRef = mapped
    }

    /**
     * @param value Resources represents the minimum resources the volume should have. If RecoverVolumeExpansionFailure feature is enabled users are allowed to specify resource requirements that are lower than previous value but must still be higher than capacity recorded in the status field of the claim. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#resources
     */
    @JvmName("ndgvynjukpujejse")
    public suspend fun resources(`value`: VolumeClaimResourceRequirementsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resources = mapped
    }

    /**
     * @param argument Resources represents the minimum resources the volume should have. If RecoverVolumeExpansionFailure feature is enabled users are allowed to specify resource requirements that are lower than previous value but must still be higher than capacity recorded in the status field of the claim. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#resources
     */
    @JvmName("wrelviramskjapku")
    public suspend
    fun resources(argument: suspend VolumeClaimResourceRequirementsArgsBuilder.() -> Unit) {
        val toBeMapped = VolumeClaimResourceRequirementsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.resources = mapped
    }

    /**
     * @param value A label query over volumes to consider for binding.
     */
    @JvmName("elumglkqdjjulgwi")
    public suspend fun selector(`value`: VolumeClaimSpecSelectorArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.selector = mapped
    }

    /**
     * @param argument A label query over volumes to consider for binding.
     */
    @JvmName("hypilntyijrgklei")
    public suspend fun selector(argument: suspend VolumeClaimSpecSelectorArgsBuilder.() -> Unit) {
        val toBeMapped = VolumeClaimSpecSelectorArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.selector = mapped
    }

    /**
     * @param value Name of the StorageClass required by the claim. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#class-1
     */
    @JvmName("qufnpkxfhcxewvnh")
    public suspend fun storageClassName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageClassName = mapped
    }

    /**
     * @param value volumeMode defines what type of volume is required by the claim. Value of Filesystem is implied when not included in claim spec. This is a beta feature.
     */
    @JvmName("awfxetjijtousbyy")
    public suspend fun volumeMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.volumeMode = mapped
    }

    /**
     * @param value VolumeName is the binding reference to the PersistentVolume backing this claim.
     */
    @JvmName("belhienjoiuefduu")
    public suspend fun volumeName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.volumeName = mapped
    }

    internal fun build(): VolumeClaimSpecArgs = VolumeClaimSpecArgs(
        accessModes = accessModes,
        dataSource = dataSource,
        dataSourceRef = dataSourceRef,
        resources = resources,
        selector = selector,
        storageClassName = storageClassName,
        volumeMode = volumeMode,
        volumeName = volumeName,
    )
}
