@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.inputs

import com.pulumi.azurenative.iotoperationsmq.inputs.VolumeClaimSpecSelectorArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * VolumeClaimSpecSelector properties
 * @property matchExpressions MatchExpressions is a list of label selector requirements. The requirements are ANDed.
 * @property matchLabels MatchLabels is a map of {key,value} pairs. A single {key,value} in the matchLabels map is equivalent to an element of matchExpressions, whose key field is "key", the operator is "In", and the values array contains only "value". The requirements are ANDed.
 */
public data class VolumeClaimSpecSelectorArgs(
    public val matchExpressions: Output<List<VolumeClaimSpecSelectorMatchExpressionsArgs>>? = null,
    public val matchLabels: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.iotoperationsmq.inputs.VolumeClaimSpecSelectorArgs> {
    override fun toJava(): com.pulumi.azurenative.iotoperationsmq.inputs.VolumeClaimSpecSelectorArgs =
        com.pulumi.azurenative.iotoperationsmq.inputs.VolumeClaimSpecSelectorArgs.builder()
            .matchExpressions(
                matchExpressions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .matchLabels(
                matchLabels?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [VolumeClaimSpecSelectorArgs].
 */
@PulumiTagMarker
public class VolumeClaimSpecSelectorArgsBuilder internal constructor() {
    private var matchExpressions: Output<List<VolumeClaimSpecSelectorMatchExpressionsArgs>>? = null

    private var matchLabels: Output<Map<String, String>>? = null

    /**
     * @param value MatchExpressions is a list of label selector requirements. The requirements are ANDed.
     */
    @JvmName("aqicovbiuhprysnb")
    public suspend
    fun matchExpressions(`value`: Output<List<VolumeClaimSpecSelectorMatchExpressionsArgs>>) {
        this.matchExpressions = value
    }

    @JvmName("xqjbbnlahprlpgyk")
    public suspend fun matchExpressions(
        vararg
        values: Output<VolumeClaimSpecSelectorMatchExpressionsArgs>,
    ) {
        this.matchExpressions = Output.all(values.asList())
    }

    /**
     * @param values MatchExpressions is a list of label selector requirements. The requirements are ANDed.
     */
    @JvmName("gpgtocfsbdlvqjjp")
    public suspend
    fun matchExpressions(values: List<Output<VolumeClaimSpecSelectorMatchExpressionsArgs>>) {
        this.matchExpressions = Output.all(values)
    }

    /**
     * @param value MatchLabels is a map of {key,value} pairs. A single {key,value} in the matchLabels map is equivalent to an element of matchExpressions, whose key field is "key", the operator is "In", and the values array contains only "value". The requirements are ANDed.
     */
    @JvmName("gcfjempwvpxfaaav")
    public suspend fun matchLabels(`value`: Output<Map<String, String>>) {
        this.matchLabels = value
    }

    /**
     * @param value MatchExpressions is a list of label selector requirements. The requirements are ANDed.
     */
    @JvmName("mpnxeplmcmrpwxsd")
    public suspend fun matchExpressions(`value`: List<VolumeClaimSpecSelectorMatchExpressionsArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.matchExpressions = mapped
    }

    /**
     * @param argument MatchExpressions is a list of label selector requirements. The requirements are ANDed.
     */
    @JvmName("nnpkchxgwvjaripu")
    public suspend
    fun matchExpressions(argument: List<suspend VolumeClaimSpecSelectorMatchExpressionsArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            VolumeClaimSpecSelectorMatchExpressionsArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.matchExpressions = mapped
    }

    /**
     * @param argument MatchExpressions is a list of label selector requirements. The requirements are ANDed.
     */
    @JvmName("dtlbvrrbtjlcjtmr")
    public suspend fun matchExpressions(
        vararg
        argument: suspend VolumeClaimSpecSelectorMatchExpressionsArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            VolumeClaimSpecSelectorMatchExpressionsArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.matchExpressions = mapped
    }

    /**
     * @param argument MatchExpressions is a list of label selector requirements. The requirements are ANDed.
     */
    @JvmName("stkmwiykujwaaenv")
    public suspend
    fun matchExpressions(argument: suspend VolumeClaimSpecSelectorMatchExpressionsArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            VolumeClaimSpecSelectorMatchExpressionsArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.matchExpressions = mapped
    }

    /**
     * @param values MatchExpressions is a list of label selector requirements. The requirements are ANDed.
     */
    @JvmName("cfjebsapbirqcocr")
    public suspend fun matchExpressions(vararg values: VolumeClaimSpecSelectorMatchExpressionsArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.matchExpressions = mapped
    }

    /**
     * @param value MatchLabels is a map of {key,value} pairs. A single {key,value} in the matchLabels map is equivalent to an element of matchExpressions, whose key field is "key", the operator is "In", and the values array contains only "value". The requirements are ANDed.
     */
    @JvmName("ynebacbctyqaogeo")
    public suspend fun matchLabels(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.matchLabels = mapped
    }

    /**
     * @param values MatchLabels is a map of {key,value} pairs. A single {key,value} in the matchLabels map is equivalent to an element of matchExpressions, whose key field is "key", the operator is "In", and the values array contains only "value". The requirements are ANDed.
     */
    @JvmName("pumnphnxldtctjyq")
    public fun matchLabels(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.matchLabels = mapped
    }

    internal fun build(): VolumeClaimSpecSelectorArgs = VolumeClaimSpecSelectorArgs(
        matchExpressions = matchExpressions,
        matchLabels = matchLabels,
    )
}
