@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Defines the Docker image details
 * @property pullPolicy Image pull policy.
 * @property pullSecrets Image pull secrets.
 * @property repository The Docker image name.
 * @property tag The Docker  image tag.
 */
public data class ContainerImageResponse(
    public val pullPolicy: String? = null,
    public val pullSecrets: String? = null,
    public val repository: String,
    public val tag: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.iotoperationsmq.outputs.ContainerImageResponse):
            ContainerImageResponse = ContainerImageResponse(
            pullPolicy = javaType.pullPolicy().map({ args0 -> args0 }).orElse(null),
            pullSecrets = javaType.pullSecrets().map({ args0 -> args0 }).orElse(null),
            repository = javaType.repository(),
            tag = javaType.tag(),
        )
    }
}
