@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Delta table schema properties
 * @property format Delta table format supported.
 * @property mapping Delta table schema mapping.
 * @property name Delta table schema name.
 * @property optional Delta table schema optional.
 */
public data class DeltaTableSchemaResponse(
    public val format: String,
    public val mapping: String,
    public val name: String,
    public val optional: Boolean,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.iotoperationsmq.outputs.DeltaTableSchemaResponse):
            DeltaTableSchemaResponse = DeltaTableSchemaResponse(
            format = javaType.format(),
            mapping = javaType.mapping(),
            name = javaType.name(),
            optional = javaType.optional(),
        )
    }
}
