@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * MQ mqttBridgeTopicMap resource
 * @property extendedLocation Extended Location
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property location The geo-location where the resource lives
 * @property mqttBridgeConnectorRef The MqttBridgeConnector CRD it refers to.
 * @property name The name of the resource
 * @property provisioningState The status of the last operation.
 * @property routes The route details for MqttBridge connector.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetMqttBridgeTopicMapResult(
    public val extendedLocation: ExtendedLocationPropertyResponse,
    public val id: String,
    public val location: String,
    public val mqttBridgeConnectorRef: String,
    public val name: String,
    public val provisioningState: String,
    public val routes: List<MqttBridgeRoutesResponse>? = null,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.iotoperationsmq.outputs.GetMqttBridgeTopicMapResult):
            GetMqttBridgeTopicMapResult = GetMqttBridgeTopicMapResult(
            extendedLocation = javaType.extendedLocation().let({ args0 ->
                com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.ExtendedLocationPropertyResponse.Companion.toKotlin(args0)
            }),
            id = javaType.id(),
            location = javaType.location(),
            mqttBridgeConnectorRef = javaType.mqttBridgeConnectorRef(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            routes = javaType.routes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.MqttBridgeRoutesResponse.Companion.toKotlin(args0)
                })
            }),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
