@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 * Kafka RemoteBrokerConnection Authentication methods
 * @property authType The type of authentication to use for Kafka remote broker.
 * @property enabled If authentication is enabled for Kafka remote broker.
 */
public data class KafkaRemoteBrokerAuthenticationPropertiesResponse(
    public val authType: KafkaRemoteBrokerAuthenticationTypesResponse? = null,
    public val enabled: Boolean,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.iotoperationsmq.outputs.KafkaRemoteBrokerAuthenticationPropertiesResponse):
            KafkaRemoteBrokerAuthenticationPropertiesResponse =
            KafkaRemoteBrokerAuthenticationPropertiesResponse(
                authType = javaType.authType().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.KafkaRemoteBrokerAuthenticationTypesResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                enabled = javaType.enabled(),
            )
    }
}
