@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.outputs

import kotlin.Suppress

/**
 * Kafka RemoteBrokerConnection Authentication types. NOTE - Enum only one method is allowed to be passed.
 * @property sasl Sasl remote broker authentication method.
 * @property systemAssignedManagedIdentity Managed identity remote broker authentication method.
 * @property x509 X509 remote broker authentication method.
 */
public data class KafkaRemoteBrokerAuthenticationTypesResponse(
    public val sasl: SaslRemoteBrokerBasicAuthenticationResponse? = null,
    public val systemAssignedManagedIdentity: ManagedIdentityAuthenticationResponse? = null,
    public val x509: KafkaX509AuthenticationResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.iotoperationsmq.outputs.KafkaRemoteBrokerAuthenticationTypesResponse):
            KafkaRemoteBrokerAuthenticationTypesResponse = KafkaRemoteBrokerAuthenticationTypesResponse(
            sasl = javaType.sasl().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.SaslRemoteBrokerBasicAuthenticationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            systemAssignedManagedIdentity = javaType.systemAssignedManagedIdentity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.ManagedIdentityAuthenticationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            x509 = javaType.x509().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.KafkaX509AuthenticationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
