@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Kafka to Mqtt route properties
 * @property consumerGroupId The consumer group id to use.
 * @property kafkaTopic The kafka topic to pull from.
 * @property mqttTopic The mqtt topic to publish to.
 * @property name The name of the route.
 * @property qos The qos to use for mqtt.
 */
public data class KafkaToMqttRoutesResponse(
    public val consumerGroupId: String? = null,
    public val kafkaTopic: String,
    public val mqttTopic: String,
    public val name: String,
    public val qos: Int? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.iotoperationsmq.outputs.KafkaToMqttRoutesResponse):
            KafkaToMqttRoutesResponse = KafkaToMqttRoutesResponse(
            consumerGroupId = javaType.consumerGroupId().map({ args0 -> args0 }).orElse(null),
            kafkaTopic = javaType.kafkaTopic(),
            mqttTopic = javaType.mqttTopic(),
            name = javaType.name(),
            qos = javaType.qos().map({ args0 -> args0 }).orElse(null),
        )
    }
}
