@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.outputs

import kotlin.Suppress

/**
 * KeyVault certificate properties
 * @property vault KeyVault properties.
 * @property vaultCaChainSecret KeyVault CA chain secret details.
 * @property vaultCert KeyVault Cert secret details.
 */
public data class KeyVaultCertificatePropertiesResponse(
    public val vault: KeyVaultConnectionPropertiesResponse,
    public val vaultCaChainSecret: KeyVaultSecretObjectResponse? = null,
    public val vaultCert: KeyVaultSecretObjectResponse,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.iotoperationsmq.outputs.KeyVaultCertificatePropertiesResponse):
            KeyVaultCertificatePropertiesResponse = KeyVaultCertificatePropertiesResponse(
            vault = javaType.vault().let({ args0 ->
                com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.KeyVaultConnectionPropertiesResponse.Companion.toKotlin(args0)
            }),
            vaultCaChainSecret = javaType.vaultCaChainSecret().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.KeyVaultSecretObjectResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            vaultCert = javaType.vaultCert().let({ args0 ->
                com.pulumi.azurenative.iotoperationsmq.kotlin.outputs.KeyVaultSecretObjectResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
