@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * PrincipalDefinition properties of Basic Rule
 * @property attributes A list of key-value pairs that match the attributes of the clients. The attributes are case-sensitive and must match the attributes provided by the clients during authentication.
 * @property clientids A list of client IDs that match the clients. The client IDs are case-sensitive and must match the client IDs provided by the clients during connection.
 * @property usernames A list of usernames that match the clients. The usernames are case-sensitive and must match the usernames provided by the clients during authentication.
 */
public data class PrincipalDefinitionResponse(
    public val attributes: List<Map<String, String>>? = null,
    public val clientids: List<String>? = null,
    public val usernames: List<String>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.iotoperationsmq.outputs.PrincipalDefinitionResponse):
            PrincipalDefinitionResponse = PrincipalDefinitionResponse(
            attributes = javaType.attributes().map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }),
            clientids = javaType.clientids().map({ args0 -> args0 }),
            usernames = javaType.usernames().map({ args0 -> args0 }),
        )
    }
}
