@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsmq.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * VolumeClaimSpecSelectorMatchExpressions properties
 * @property key key is the label key that the selector applies to.
 * @property operator operator represents a key's relationship to a set of values. Valid operators are In, NotIn, Exists and DoesNotExist.
 * @property values values is an array of string values. If the operator is In or NotIn, the values array must be non-empty. If the operator is Exists or DoesNotExist, the values array must be empty. This array is replaced during a strategic merge patch.
 */
public data class VolumeClaimSpecSelectorMatchExpressionsResponse(
    public val key: String,
    public val `operator`: String,
    public val values: List<String>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.iotoperationsmq.outputs.VolumeClaimSpecSelectorMatchExpressionsResponse):
            VolumeClaimSpecSelectorMatchExpressionsResponse =
            VolumeClaimSpecSelectorMatchExpressionsResponse(
                key = javaType.key(),
                `operator` = javaType.`operator`(),
                values = javaType.values().map({ args0 -> args0 }),
            )
    }
}
