@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsorchestrator.kotlin.inputs

import com.pulumi.azurenative.iotoperationsorchestrator.inputs.ReconciliationPolicyArgs.builder
import com.pulumi.azurenative.iotoperationsorchestrator.kotlin.enums.ReconciliationPolicies
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Reconciliation Policy.
 * @property interval Policy interval.
 * @property type Policy type
 */
public data class ReconciliationPolicyArgs(
    public val interval: Output<String>? = null,
    public val type: Output<Either<String, ReconciliationPolicies>>,
) :
    ConvertibleToJava<com.pulumi.azurenative.iotoperationsorchestrator.inputs.ReconciliationPolicyArgs> {
    override fun toJava():
        com.pulumi.azurenative.iotoperationsorchestrator.inputs.ReconciliationPolicyArgs =
        com.pulumi.azurenative.iotoperationsorchestrator.inputs.ReconciliationPolicyArgs.builder()
            .interval(interval?.applyValue({ args0 -> args0 }))
            .type(
                type.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ReconciliationPolicyArgs].
 */
@PulumiTagMarker
public class ReconciliationPolicyArgsBuilder internal constructor() {
    private var interval: Output<String>? = null

    private var type: Output<Either<String, ReconciliationPolicies>>? = null

    /**
     * @param value Policy interval.
     */
    @JvmName("eketlsowfhlrbvrr")
    public suspend fun interval(`value`: Output<String>) {
        this.interval = value
    }

    /**
     * @param value Policy type
     */
    @JvmName("fxvljobagamipuxr")
    public suspend fun type(`value`: Output<Either<String, ReconciliationPolicies>>) {
        this.type = value
    }

    /**
     * @param value Policy interval.
     */
    @JvmName("ltolusylfdhrluqr")
    public suspend fun interval(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.interval = mapped
    }

    /**
     * @param value Policy type
     */
    @JvmName("rsxixdwasmiukpkw")
    public suspend fun type(`value`: Either<String, ReconciliationPolicies>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Policy type
     */
    @JvmName("trixsigwylvytuee")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ReconciliationPolicies>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Policy type
     */
    @JvmName("rlqbmykvhahyiafd")
    public fun type(`value`: ReconciliationPolicies) {
        val toBeMapped = Either.ofRight<String, ReconciliationPolicies>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ReconciliationPolicyArgs = ReconciliationPolicyArgs(
        interval = interval,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
