@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.iotoperationsorchestrator.kotlin.inputs

import com.pulumi.azurenative.iotoperationsorchestrator.inputs.TargetSelectorPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Properties of the reference target.
 * @property name Name of the target.
 */
public data class TargetSelectorPropertiesArgs(
    public val name: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.iotoperationsorchestrator.inputs.TargetSelectorPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.iotoperationsorchestrator.inputs.TargetSelectorPropertiesArgs =
        com.pulumi.azurenative.iotoperationsorchestrator.inputs.TargetSelectorPropertiesArgs.builder()
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TargetSelectorPropertiesArgs].
 */
@PulumiTagMarker
public class TargetSelectorPropertiesArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    /**
     * @param value Name of the target.
     */
    @JvmName("cnedkvbadjepaelr")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Name of the target.
     */
    @JvmName("vpiopabmvjetsluh")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): TargetSelectorPropertiesArgs = TargetSelectorPropertiesArgs(
        name = name,
    )
}
