@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.keyvault.kotlin

import com.pulumi.azurenative.keyvault.kotlin.outputs.AccessPolicyEntry
import com.pulumi.azurenative.keyvault.kotlin.outputs.AccessPolicyEntry.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [AccessPolicy].
 */
@PulumiTagMarker
public class AccessPolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AccessPolicyArgs = AccessPolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AccessPolicyArgsBuilder.() -> Unit) {
        val builder = AccessPolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): AccessPolicy {
        val builtJavaResource = com.pulumi.azurenative.keyvault.AccessPolicy(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return AccessPolicy(builtJavaResource)
    }
}

/**
 * Key Vault Access Policy for managing policies on existing vaults.
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:keyvault:AccessPolicy myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.KeyVault/vaults/{vaultName}/accessPolicy
 * ```
 */
public class AccessPolicy internal constructor(
    override val javaResource: com.pulumi.azurenative.keyvault.AccessPolicy,
) : KotlinCustomResource(javaResource, AccessPolicyMapper) {
    /**
     * The definition of the access policy.
     */
    public val policy: Output<AccessPolicyEntry>?
        get() = javaResource.policy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Name of the resource group that contains the vault.
     */
    public val resourceGroupName: Output<String>?
        get() = javaResource.resourceGroupName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Name of the Key Vault.
     */
    public val vaultName: Output<String>?
        get() = javaResource.vaultName().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object AccessPolicyMapper : ResourceMapper<AccessPolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.keyvault.AccessPolicy::class == javaResource::class

    override fun map(javaResource: Resource): AccessPolicy = AccessPolicy(
        javaResource as
            com.pulumi.azurenative.keyvault.AccessPolicy,
    )
}

/**
 * @see [AccessPolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AccessPolicy].
 */
public suspend fun accessPolicy(
    name: String,
    block: suspend AccessPolicyResourceBuilder.() -> Unit,
): AccessPolicy {
    val builder = AccessPolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AccessPolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun accessPolicy(name: String): AccessPolicy {
    val builder = AccessPolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
